/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.util.LocalizedMessageAware;
import java.io.Serializable;

public class OutputOption
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -879599688492364852L;
    private double jpegQuality = 1.0;
    private boolean enableZoom;
    private double zoomFactor = 1.0;
    private ZoomRenderingType zoomRenderingType = ZoomRenderingType.NONE;
    private PictureMode pictureMode = PictureMode.NORMAL;
    private boolean forceBgColor;

    public OutputOption clone() {
        try {
            return (OutputOption)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public double getJpegQuality() {
        return this.jpegQuality;
    }

    public void setJpegQuality(double jpegQuality) {
        if (jpegQuality < 0.1) {
            jpegQuality = 0.1;
        }
        if (jpegQuality > 1.0) {
            jpegQuality = 1.0;
        }
        this.jpegQuality = jpegQuality;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        if (zoomFactor < 0.1) {
            zoomFactor = 0.1;
        }
        if (zoomFactor > 10.0) {
            zoomFactor = 10.0;
        }
        this.zoomFactor = zoomFactor;
    }

    public ZoomRenderingType getZoomRenderingType() {
        return this.zoomRenderingType;
    }

    public void setZoomRenderingType(ZoomRenderingType zoomRenderingType) {
        if (zoomRenderingType == null) {
            zoomRenderingType = ZoomRenderingType.NONE;
        }
        this.zoomRenderingType = zoomRenderingType;
    }

    public PictureMode getPictureMode() {
        return this.pictureMode;
    }

    public void setPictureMode(PictureMode pictureMode) {
        if (pictureMode == null) {
            pictureMode = PictureMode.NORMAL;
        }
        this.pictureMode = pictureMode;
    }

    public boolean isForceBgColor() {
        return this.forceBgColor;
    }

    public void setForceBgColor(boolean forceBgColor) {
        this.forceBgColor = forceBgColor;
    }

    public void setEnableZoom(boolean enableZoom) {
        this.enableZoom = enableZoom;
    }

    public boolean isEnableZoom() {
        return this.enableZoom;
    }

    public void changeRecommend() {
        this.zoomRenderingType = this.zoomFactor > 1.0 ? ZoomRenderingType.BICUBIC : (this.zoomFactor < 1.0 ? ZoomRenderingType.BILINER : ZoomRenderingType.NONE);
    }

    public String toString() {
        return "(OutputOption:(jpegQuality:" + this.jpegQuality + ")(enableZoom:" + this.enableZoom + ")(zoomFactor:" + this.zoomFactor + ")(renderingType:" + this.zoomRenderingType + ")(pictureMode:" + this.pictureMode + ")(forceBgColor:" + this.forceBgColor + "))";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PictureMode implements LocalizedMessageAware
    {
        NORMAL,
        OPAQUE,
        GRAY,
        ALPHA;


        @Override
        public String getLocalizedResourceId() {
            return "outputOption.pictureMode." + this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZoomRenderingType implements LocalizedMessageAware
    {
        NONE,
        BILINER,
        BICUBIC;


        @Override
        public String getLocalizedResourceId() {
            return "outputOption.zoomRenderingType." + this.name();
        }
    }
}

