/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#) $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/ITRON/servers/database.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */

static char rcs[] = "@(#) $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/ITRON/servers/database.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";


/*
 * $Log: database.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.1  1999-04-18 17:48:36  monaka
 * Port-manager and libkernel.a is moved to ITRON. I guess it is reasonable. At least they should not be in BTRON/.
 *
 * Revision 1.1  1996/07/23 00:03:04  night
 * IBM PC ѤκǽϿ
 *
 * Revision 1.4  1995/12/05 15:16:28  night
 * ݡȥơ֥ 0  1 ޤǤĴ٤Ƥʤä
 *  MAX_PORT_ENTRY(= 100)ޤǸ褦ˤ
 *
 * Revision 1.3  1995/09/21  15:51:48  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.2  1995/06/26  15:18:56  night
 * Ĥ printf  DEBUG ޥǰϤ
 *
 * Revision 1.1  1995/03/18  14:12:47  night
 * ǽϿ
 *
 *
 */

/*
 * åХåեǡ١뤿Υ⥸塼롣
 * ̾ȥåХåե ID ȤӤĤ롣
 *
 * Υ⥸塼ϡФƼδؿ롣
 *
 *   init_regist_table (void)
 *   regist_database (PORT_NAME *name, ID port, ID task)
 *   unregist_database (PORT_NAME *name, ID port, ID task)
 *   find_database (PORT_NAME *name, ID *port)
 *
 *
 * ǡδˡȤƤϡñʥơ֥Ǵ롣
 * ʤƤǽΥȥϿõȤˤϡ
 * ǽΥȥ꤫֤õƤ
 *
 */


/*
 * ɬפʥ󥯥롼ɥեɤ߹ߡ
 */
#include <itron.h>
#include <errno.h>
#include <types.h>
#include "port-manager.h"


/*
 * ǡϿ륨ȥꡣ
 * ̾ȥåХåե ID Ͽ ID  
 * 3 Ĥξ롣
 * ι¤ΤϡΥե椷Ȥʤ
 *
 */
struct data_entry_t
{
  PORT_NAME	name;		/* åХåե˷ӤĤ̾   */
				/* ϿȤ˻ꤹ롣               */

  ID		port;		/* åХåե ID                  */
				/* Ǥͤ 0 ΤȤˤϡΥ    */
  				/* ȥϡȤäƤʤȤɽ     */

  ID		task;		/* åХåեϿ */
};


/*
 * ơ֥
 */
static struct data_entry_t	table[MAX_PORT_ENTRY];


/*
 * ơ֥뤫̾ˤäƥȥ򸡺ؿ
 * unregist_database()  find_database() ǻѤ롣
 */
static W	find_entry (PORT_NAME name);


/*
 * ǡ١ν
 * ơ֥ table ѿǤꤹ롣
 * (0 )
 */
void
init_regist_table (void)
{
  bzero (table, sizeof (table));
}


/*
 * ǡϿ
 * table ѿζƤ륨ȥ򸫤ĤåХåե
 * Ͽ롣
 *
 */
PORT_MANAGER_ERROR
regist_database (PORT_NAME name, ID port, ID task)
{
  W	counter;		/* Ƥ륨ȥơ֥뤫 */
				/* ĤȤ˻Ѥ륫   */

  /*
   * ơ֥Ʊ̾Υȥ꤬ʤ򸡺롣
   * ⤷Ʊ̾ĥȥ꤬äˤϡ
   * E_PORT_DUPLICATION Υ顼֤
   */
  if (find_entry (name) >= 0)
    {
      return (E_PORT_DUPLICATION);	/* Ʊ̾ĥȥ꤬ */
					/* Ǥˤä顼֤   */
    }

  /*
   * ơ֥ƬƤ륨ȥõ
   */
  for (counter = 0; counter < MAX_PORT_ENTRY; counter++)
    {
      /*
       * ⤷ȥ ID Ǥ 0 ʤСΥȥ
       * ȤƤʤ
       */
      if (table[counter].port == 0)
	{
	  /*
	   * Ƥ륨ȥ򸫤Ĥ
	   * åХåեϿ롣
	   */
	  strncpy (table[counter].name, name, (PORT_NAME_LEN + 1));
	  table[counter].port = port;
	  table[counter].task = task;
#ifdef DEBUG
	  dbg_printf ("regist: %s, %s\n", &(table[counter].name), name);
#endif /* DEBUG */
	  return (E_PORT_OK);
	}
    }

  /*
   * Ƥ륨ȥ꤬ȯǤʤä
   * E_PORT_FULL Υ顼֤
   */
  return (E_PORT_FULL);
}


/*
 * ǡ١ꤷ̾ĥȥ롣
 * ⤷б륨ȥ꤬ĤʤäˤϡE_PORT_NOTFOUND 
 * Υ顼֤
 *
 *  name ǻꤷȥ򸫤ĤȥƤ 0 롣
 * 
 * δؿϡåХåե ID  port ֤
 *
 */
PORT_MANAGER_ERROR
unregist_database (PORT_NAME name, ID *port, ID task)
{
  W	index;		/* ǡ١鸫Ĥȥ */

  index = find_entry (name);
  if (index < 0)
    {
      return (E_PORT_NOTFOUND);	/* ȥֹ椬 -1 ä;       */
				/*  name ˳륨ȥ꤬  */
				/* ʤäΤǡE_PORT_NOTFOUND  */
      				/* 顼֤                  */
    }

  /*
   * åХåե ID  port 롣
   */
  *port = table[index].port;

  /*
   * åХåեϿ׵Ԥä
   * ۤʤäƤˤϡE_PORT_INVALID Υ顼Ȥ롣
   */
  if (table[index].task	 != task)
    {
      return (E_PORT_INVALID);
    }

  /*
   * find_entry() ˤäơȯȥ 0 롣
   */
  bzero (&table[index], sizeof (struct data_entry_t));

  return (E_PORT_OK);  
}


/*
 *  name ǻꤷ̾ĥȥ򸫤ĤƥåХåե 
 * ID ֤
 * ⤷ơ֥˳̾ĥȥ꤬ʤäˤϡ
 * E_PORT_NOTFOUND Υ顼֤
 *
 */
PORT_MANAGER_ERROR
find_database (PORT_NAME name, ID *port)
{
  W	index;	/* ǡ١ơ֥뤫鸫Ĥȥɽ  */
		/* table ѿΥǥå			   */

  /*
   * б륨ȥ꤬ʤõ
   * find_entry() ȤäƤ롣
   */
  index = find_entry (name);
  if (index == -1)
    {
      /*
       * find_entry() ֤ͤ -1 ä
       * б륨ȥ꤬ʤΤǡE_PORT_NOTFOUND Υ顼֤
       */
      return (E_PORT_NOTFOUND);
    }

  /*
   *  port õФȥäƤåХåե id 
   * ꤹ롣 
   */
  *port = table[index].port;

  return (E_PORT_OK);		/* ｪλE_PORT_OK ֤ */
}


/*
 * ơ֥뤫饨ȥ򸫤Ĥ뤿βؿ
 * ֤ͤȤƾơ֥Υǥåֹ֤
 * ơ֥뤫 name б̾ĥȥ꤬ȯǤʤ
 * ˤϡ-1 ֤
 */
static W
find_entry (PORT_NAME name)
{
  W	index;			/* ơ֥򥵡Ȥˡ */
				/* Ѥ륫󥿡                   */

  /*
   * ̾ĥȥ꤬ʤɤơ֥ (table) 
   * Ƭ鸡롣
   */
  for (index = 0; index < MAX_PORT_ENTRY; index++)
    {
#if defined(DEBUG)
      dbg_printf ("find_entry: <%s>, <%s>\n", 
		  table[index].name, name);
#endif /* DEBUG */

      if (strncmp (name, table[index].name, PORT_NAME_LEN) == 0)
	{
	  /*
	   *  name Ʊ̾ĥȥȯ
	   * ơ֥ ǥå֤ͤ
	   */
	  return (index);
	}
    }

  /*
   * ơ֥ˤϡ륨ȥ꤬ʤä
   * -1 ֤
   */
  return (-1);
}
