#ifndef __BTRON_PRCMGR_H__
#define __BTRON_PRCMGR_H__

/* process state */
typedef struct {
        UW state;    /* vZX̏ */
        UW priority; /* ݂̃vZX̗Dx */
        W parpid;    /* evZX̃vZXID */
} P_STATE;

/* process user information */
typedef struct {
        TCODE usr_name[14];     /* [U (+ B2) */
        TCODE grp_name1[14];    /* O[v1 (+ B2) */
        TCODE grp_name2[14];    /* O[v2 (+ B2) */
        TCODE grp_name3[14];    /* O[v3 (+ B2) */
        TCODE grp_name4[14];    /* O[v4 (+ B2) */
        W level;             /* [Ux (0-15) */
        W net_level;         /* lbg[NE[Ux (1-15) */
} P_USER;

/* process information */
typedef struct {
        ULONG etime;            /* Ă̗݌voߎ (sec) */
        ULONG utime;            /* vZXŔ₵݌vCPU (msec) */
        ULONG stime;            /* VXeł̃vZX̂߂ɔ₵݌vCPU (msec) */
        ULONG tmem;             /* sɕKvƂvZXŜ̃TCY (byte) */
        ULONG wmem;             /* ݃vZXɊĂTCY (byte) */
        LONG resv[11];          /* \ */
} P_INFO;

/* IɊւ萔 */
#define TERM_NRM 0x0000 /* w肵vZX̂݋I */
#define TERM_ALL 0x0001 /* qvZX܂Ŋ܂߂I */

/* DxɊւ萔 */
#define P_ABS    0x0000 /* Dx̐Ύw */
#define P_REL    0x0001 /* Dx̑Ύw */

/* sԂɊւ萔 */
#define P_LOCK   0x0001 /* bN */
#define P_WAIT   0x2000 /* ҂ */
#define P_READY  0x4000 /* s\ */
#define P_RUN    0x8000 /* s */


/* message structure */
typedef union {
        struct {
                W pid;
                W code;
        } ABORT; /* qvZẌُI */
        struct {
                W pid;
                W code;
        } EXIT; /* qvZX̐I */
        struct {
                W pid;
                W code;
        } TERM; /* qvZX̋I */
        struct {
                W code;
        } TMOUT; /* vZX̃^CAEg */
        struct {
                LONG iopac;
        } IOREQ; /* hCovZXւ̗v */
        struct {
                W code;
        } DOWN; /* VXe~v */
        struct {
                B msg_str[32];
        } ANYMSG; /* ėp */
} MSGBODY;

typedef struct {
        W msg_type;          /* bZ[W^Cv */
        W msg_size;          /* bZ[WTCY (oCg) */
        B msg_body[0];       /* bZ[W{ (msg_sizeoCg) */
} MESSAGE;

/* bZ[W̒` */
#define WAIT    0x0000 /* L[ɓ܂ő҂ */
#define NOWAIT  0x0001 /* L[ɓ܂ő҂Ȃ */
#define CONFM   0x0002 /* Wait until the message is received. */
#define CLR     0x0000 /* Remove from the queue. */
#define NOCLR   0x0008 /* Leave it on the queue. */
#define CHECK   0x0002 /* Checking whether messages are available or not. */

/* System pre-defined message handler. */
#define MH_NONE  ((FUNCP)1)
#define MH_BREAK ((FUNCP)2)
#define MH_TERM  ((FUNCP)3)

/* defines used for message ID */
#define MS_ABORT (1) /* qvZẌُI */
#define MS_EXIT  (2) /* qvZX̐I */
#define MS_TERM  (3) /* qvZX̋I */
#define MS_TMOUT (4) /* ^CAEg */
#define MS_IOREQ (5) /* fohvZXv */
#define MS_SYS   (6) /* reserved */
#define MS_DOWN  (7) /* VXe~v */
#define MS_SRSV0 (8) /* reserved */
#define MS_SRSV1 (9) /* reserved */
#define MS_SRSV2 (10) /* reserved */
#define MS_MNG0  (11) /* reserved */
#define MS_MNG1  (12) /* EChE}l[WpU[u */
#define MS_MNG2  (13) /* EChE}l[WpU[u */
#define MS_MNG3  (14) /* g/g}l[WpU[u */
#define MS_MNG4  (15) /* Xv[p reserved */
#define MS_MNG5  (16) /* Xv[p reserved */
#define MS_MNG6  (17) /* LANp reserved */
#define MS_MNG7  (18) /* LANp reserved */
#define MS_MNG8  (19) /* reserved */
#define MS_MNG9  (20) /* reserved */
#define MS_MNG10 (21) /* reserved */
#define MS_MNG11 (22) /* reserved */
#define MS_MNG12 (23) /* reserved */
#define MS_TYPE0 (24) /* AvP[VbZ[W #0 */
#define MS_TYPE1 (25) /* AvP[VbZ[W #1 */
#define MS_TYPE2 (26) /* AvP[VbZ[W #2 */
#define MS_TYPE3 (27) /* AvP[VbZ[W #3 */
#define MS_TYPE4 (28) /* AvP[VbZ[W #4 */
#define MS_TYPE5 (29) /* AvP[VbZ[W #5 */
#define MS_TYPE6 (30) /* AvP[VbZ[W #6 */
#define MS_TYPE7 (31) /* AvP[VbZ[W #7 */

#define MM_ABORT (0x00000001) /* qvZẌُI */
#define MM_EXIT  (0x00000002) /* qvZX̐I */
#define MM_TERM  (0x00000004) /* qvZX̋I */
#define MM_TMOUT (0x00000008) /* ^CAEg */
#define MM_IOREQ (0x00000010) /* fohvZXv */
#define MM_SYS   (0x00000020) /* reserved */
#define MM_DOWN  (0x00000040) /* VXe~v */
#define MM_SRSV0 (0x00000080) /* reserved */
#define MM_SRSV1 (0x00000100) /* reserved */
#define MM_SRSV2 (0x00000200) /* reserved */
#define MM_MNG0  (0x00000400) /* reserved */
#define MM_MNG1  (0x00000800) /* EChE}l[WpU[u */
#define MM_MNG2  (0x00001000) /* EChE}l[WpU[u */
#define MM_MNG3  (0x00002000) /* g/g}l[WpU[u */
#define MM_MNG4  (0x00004000) /* Xv[p reserved */
#define MM_MNG5  (0x00008000) /* Xv[p reserved */
#define MM_MNG6  (0x00010000) /* LANp reserved */
#define MM_MNG7  (0x00020000) /* LANp reserved */
#define MM_MNG8  (0x00040000) /* reserved */
#define MM_MNG9  (0x00080000) /* reserved */
#define MM_MNG10 (0x00100000) /* reserved */
#define MM_MNG11 (0x00200000) /* reserved */
#define MM_MNG12 (0x00400000) /* reserved */
#define MM_TYPE0 (0x00800000) /* AvP[VbZ[W #0 */
#define MM_TYPE1 (0x01000000) /* AvP[VbZ[W #1 */
#define MM_TYPE2 (0x02000000) /* AvP[VbZ[W #2 */
#define MM_TYPE3 (0x04000000) /* AvP[VbZ[W #3 */
#define MM_TYPE4 (0x08000000) /* AvP[VbZ[W #4 */
#define MM_TYPE5 (0x10000000) /* AvP[VbZ[W #5 */
#define MM_TYPE6 (0x20000000) /* AvP[VbZ[W #6 */
#define MM_TYPE7 (0x40000000) /* AvP[VbZ[W #7 */
#define MM_ALL   (0x7FFFFFFF) /* S^Cvw */
#define MM_NULL  (0x00000000) /* S^CvwO */

/* for semaphoe. */
#define SEM_SYNC (0x0000) /* Syncronize semaphoe */
#define SEM_EXCL (0x4000) /* rpZ}tH */

#define DELEXIT  (0x8000) /* Delete when process is killed. */

/* for Global Name Data */
#define N_CREATE (0x0000) /* Create a new Global Name Data. */
#define N_MODIFY (0x0001) /* Modify exsisting one. */
#define N_FORCE  (0x0002) /* Force creation. */

#endif /* __BTRON_PRCMGR_H__ */



