/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/BTRON/device/wconsole/graphic.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */
static char rcsid[] = "$Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/BTRON/device/wconsole/graphic.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";

/*
 * $Log: graphic.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.5  2000-02-27 15:29:23  naniwa
 * to work as multi task OS
 *
 * Revision 1.4  2000/02/19 03:00:09  naniwa
 * to support multi window environment
 *
 * Revision 1.3  2000/01/29 16:16:31  naniwa
 * minor fix
 *
 * Revision 1.2  1999/05/29 02:55:15  naniwa
 * adjusted window design
 *
 * Revision 1.1  1999/05/15 09:56:04  naniwa
 * first version
 *
 */

#include "wconsole_internal.h"

extern ID		recv, console;
extern struct window w[];
extern int winid, max_win;

ER
box_vga (int x, int y, int width, int height, int color)
{
  struct gr_box_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_box_t);
  
  req.body.ctl_req.cmd = GR_BOX;
  param = (struct gr_box_t *)&(req.body.ctl_req.param);
  param->x = x;
  param->y = y;
  param->width = width;
  param->height = height;
  param->color = color;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}


ER
fillbox_vga (int x, int y, int width, int height, int color)
{
  struct gr_fillbox_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_fillbox_t);
  
  req.body.ctl_req.cmd = GR_FILLBOX;
  param = (struct gr_fillbox_t *)&(req.body.ctl_req.param);
  param->x = x;
  param->y = y;
  param->width = width;
  param->height = height;
  param->color = color;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}


ER
circle_vga (int x, int y, int width, int height, int color)
{
  struct gr_box_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_box_t);
  
  req.body.ctl_req.cmd = GR_CIRCLE;
  param = (struct gr_box_t *)&(req.body.ctl_req.param);
  param->x = x;
  param->y = y;
  param->width = width;
  param->height = height;
  param->color = color;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}


ER
line_vga (int x1, int y1, int x2, int y2, int color, int mode)
{
  struct gr_line_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_line_t);
  
  req.body.ctl_req.cmd = GR_LINE;
  param = (struct gr_line_t *)&(req.body.ctl_req.param);
  param->x1 = x1;
  param->y1 = y1;
  param->x2 = x2;
  param->y2 = y2;
  param->color = color;
  param->mode = mode;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.ctl_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}


#define bit_width 16
#define bit_height 16
static unsigned char bit_bits[] = {
   0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
   0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
   0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00};


ER
set_background (int width, int height, unsigned char *bitmap)
{
  struct gr_setbg_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;
  ID			tskid;

  error = get_tid (&tskid);
  if (error)
    {
      return (error);
    }

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_setbg_t);
  req.body.ctl_req.cmd = GR_SETBG;
  param = (struct gr_setbg_t *)&(req.body.ctl_req.param);
  param->caller = tskid;
  if (bitmap)
    {
      param->width = width;
      param->height = height;
      param->size = (width * height) / 8;
      param->bitmap = bitmap;
    }
  else
    {
      param->width = bit_width;
      param->height = bit_height;
      param->size = sizeof (bit_bits);
      param->bitmap = bit_bits;
    }

  param->frcolor = 1;
  param->bgcolor = 7;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}



ER
set_bitmap (int x, int y, int width, int height, int size, unsigned char *buf, int color, int bgcolor)
{
  struct gr_setbitmap_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;
  ID			tskid;


  error = get_tid (&tskid);
  if (error)
    {
      return (error);
    }

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_setbitmap_t);
  req.body.ctl_req.cmd = GR_SETBITMAP;
  param = (struct gr_setbitmap_t *)&(req.body.ctl_req.param);
  param->caller = tskid;
  param->x = x;
  param->y = y;
  param->width = width;
  param->height = height;
  param->size = size;
  param->bitmap = buf;
  param->frcolor = color;
  param->bgcolor = bgcolor;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}



ER
spl_bitmap (int x, int y, int width, int height, int size, unsigned char *buf, int color)
{
  struct gr_splbitmap_t	*param;
  DDEV_REQ		req;		/* ׵ѥå */
  DDEV_RES		res;		/* ѥå */
  W			rsize;
  ER			error;
  ID			tskid;


  error = get_tid (&tskid);
  if (error)
    {
      return (error);
    }

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_splbitmap_t);
  req.body.ctl_req.cmd = GR_SPLBITMAP;
  param = (struct gr_splbitmap_t *)&(req.body.ctl_req.param);
  param->caller = tskid;
  param->x = x;
  param->y = y;
  param->width = width;
  param->height = height;
  param->size = size;
  param->bitmap = buf;
  param->frcolor = color;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }      

  return (E_OK);
}

ER
scroll_vga(int direc, int x, int y, int width, int height, int step, int color)
{
  struct gr_scroll_t      *param;
  DDEV_REQ              req;            /* ׵ѥå */
  DDEV_RES              res;            /* ѥå */
  W                     rsize;
  ER                    error;

  req.header.mbfid = recv;
  req.header.msgtyp = DEV_CTL;
  req.body.ctl_req.len = sizeof (struct gr_scroll_t);

  req.body.ctl_req.cmd = GR_SCROLL;
  param = (struct gr_scroll_t *)&(req.body.ctl_req.param);
  param->direc = direc;
  param->x     = x;
  param->y     = y;
  param->width = width;
  param->height= height;
  param->step  = step;
  param->color = color;
  error = snd_mbf (console, sizeof (req), &req);
  if (error != E_OK)
    {
      return (error);
    }

  rsize = sizeof (res);
  error = rcv_mbf (&res, (INT *)&rsize, recv);
  if (res.body.wri_res.errcd != E_OK)
    {
      return (res.body.ctl_res.errcd);
    }

  return (E_OK);
}
/*
   This xbm font data is made from a14(7x14.pcf) font of X11.
*/

static unsigned char a14xbm[][14] = {
  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00},
  {
   0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08,
   0x00, 0x00},
  {
   0x00, 0x36, 0x24, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x50, 0x50, 0x50, 0x7e, 0x28, 0x28, 0x7e, 0x14, 0x14, 0x14,
   0x00, 0x00},
  {
   0x00, 0x00, 0x10, 0x3c, 0x52, 0x52, 0x14, 0x38, 0x50, 0x52, 0x52, 0x3c,
   0x10, 0x00},
  {
   0x00, 0x00, 0x4c, 0x52, 0x32, 0x1c, 0x10, 0x08, 0x38, 0x4c, 0x4a, 0x32,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x4c, 0x52, 0x22, 0x32, 0x4c,
   0x00, 0x00},
  {
   0x00, 0x18, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10,
   0x20, 0x40},
  {
   0x00, 0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08,
   0x04, 0x02},
  {
   0x00, 0x00, 0x10, 0x54, 0x38, 0x10, 0x38, 0x54, 0x10, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08,
   0x08, 0x04},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
   0x10, 0x00},
  {
   0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04,
   0x02, 0x02},
  {
   0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x10, 0x18, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x20, 0x30, 0x28, 0x28, 0x24, 0x24, 0x22, 0x7e, 0x20, 0x20,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x02, 0x02, 0x3e, 0x42, 0x40, 0x40, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x38, 0x44, 0x42, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x42, 0x22, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x42, 0x22, 0x1c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x10, 0x00, 0x00, 0x10, 0x38, 0x10,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x10, 0x10,
   0x08, 0x00},
  {
   0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x20, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10,
   0x00, 0x00},
  {
   0x00, 0x00, 0x38, 0x44, 0x72, 0x4a, 0x4a, 0x4a, 0x4a, 0x72, 0x04, 0x78,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3e, 0x44, 0x44, 0x44, 0x3c, 0x44, 0x44, 0x44, 0x44, 0x3e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3e, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x02,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x02, 0x72, 0x42, 0x42, 0x62, 0x5c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x70, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x1c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x22, 0x12, 0x0a, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x42, 0x46, 0x46, 0x4a, 0x52, 0x62, 0x62, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x4e, 0x52, 0x62, 0x3c,
   0x20, 0x40},
  {
   0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x12, 0x22, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x10, 0x08, 0x04, 0x04, 0x02, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x78, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
   0x08, 0x78},
  {
   0x00, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20,
   0x40, 0x40},
  {
   0x00, 0x1e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
   0x10, 0x1e},
  {
   0x00, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x7e},
  {
   0x00, 0x30, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x70, 0x4c, 0x42, 0x62, 0x5c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x46, 0x3a,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x62, 0x5c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x30, 0x48, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x22, 0x22, 0x22, 0x1c, 0x04, 0x3a,
   0x42, 0x3c},
  {
   0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x10, 0x10, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x20, 0x20, 0x00, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
   0x22, 0x1c},
  {
   0x00, 0x00, 0x02, 0x02, 0x02, 0x22, 0x12, 0x0a, 0x0e, 0x12, 0x22, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x22,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x46, 0x3a,
   0x02, 0x02},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x62, 0x5c,
   0x40, 0x40},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x02, 0x02, 0x02, 0x02,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x04, 0x18, 0x20, 0x42, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x08, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x2a, 0x2a, 0x2a, 0x2a, 0x14,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40,
   0x42, 0x3c},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x20, 0x10, 0x08, 0x08, 0x04, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x60, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x10, 0x10, 0x10, 0x10,
   0x10, 0x60},
  {
   0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
   0x08, 0x08},
  {
   0x00, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x08, 0x08, 0x08, 0x08,
   0x08, 0x06},
  {
   0x00, 0x04, 0x4a, 0x52, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00}
};

/*
   This xbm font data is made from 7x14bold(7x14B.pcf) font of X11.
*/

static unsigned char a14Bxbm[][14] = {
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18,
   0x00, 0x00},
  {
   0x7e, 0x6c, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x78, 0x78, 0x78, 0x7e, 0x3c, 0x3c, 0x7e, 0x1e, 0x1e, 0x1e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x3c, 0x5a, 0x5a, 0x1c, 0x38, 0x58, 0x5a, 0x5a, 0x3c,
   0x18, 0x00},
  {
   0x00, 0x00, 0x6c, 0x76, 0x36, 0x1c, 0x10, 0x08, 0x38, 0x6c, 0x6e, 0x36,
   0x00, 0x00},
  {
   0x00, 0x00, 0x38, 0x6c, 0x6c, 0x6c, 0x38, 0x6c, 0x76, 0x36, 0x36, 0x6c,
   0x00, 0x00},
  {
   0x1c, 0x18, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x60, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x18,
   0x30, 0x60},
  {
   0x00, 0x06, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18,
   0x0c, 0x06},
  {
   0x00, 0x00, 0x5a, 0x5a, 0x3c, 0x18, 0x3c, 0x5a, 0x5a, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18,
   0x18, 0x0c},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x60, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x18, 0x0c, 0x0c, 0x06,
   0x06, 0x06},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x1c, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x60, 0x30, 0x30, 0x18, 0x0c, 0x06, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x60, 0x38, 0x60, 0x60, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x20, 0x30, 0x30, 0x38, 0x3c, 0x34, 0x36, 0x7e, 0x20, 0x20,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x06, 0x06, 0x3e, 0x66, 0x60, 0x60, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x38, 0x6c, 0x66, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x66, 0x36, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x66, 0x36, 0x1c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18,
   0x0c, 0x00},
  {
   0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x00, 0x7e, 0x7e, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x30, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x38, 0x6c, 0x76, 0x5e, 0x5e, 0x5e, 0x5e, 0x76, 0x0c, 0x78,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3e, 0x66, 0x66, 0x26, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x1e, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x36, 0x1e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x06, 0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x06, 0x06,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x06, 0x06, 0x76, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x36, 0x1c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x36, 0x1e, 0x0e, 0x0e, 0x1e, 0x1e, 0x36, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x42, 0x66, 0x66, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x6e, 0x6e, 0x6e, 0x76, 0x76, 0x76, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x06, 0x06, 0x06, 0x06,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6e, 0x76, 0x66, 0x3c,
   0x60, 0x40},
  {
   0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x3e, 0x36, 0x66, 0x66, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x3c, 0x66, 0x66, 0x0c, 0x18, 0x18, 0x30, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x7e, 0x7e, 0x7e, 0x24,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x7e, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x7c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
   0x0c, 0x7c},
  {
   0x00, 0x06, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x18, 0x30, 0x30, 0x60,
   0x60, 0x60},
  {
   0x00, 0x3e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
   0x30, 0x3e},
  {
   0x18, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x7e, 0x7e},
  {
   0x38, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x70, 0x6c, 0x66, 0x66, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x06, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x06, 0x06, 0x06, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x7e, 0x06, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x30, 0x78, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x76, 0x36, 0x36, 0x1c, 0x04, 0x3e,
   0x66, 0x3c},
  {
   0x00, 0x00, 0x06, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
   0x36, 0x1c},
  {
   0x00, 0x00, 0x06, 0x06, 0x06, 0x26, 0x36, 0x1e, 0x1e, 0x36, 0x66, 0x46,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3e,
   0x06, 0x06},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c,
   0x60, 0x60},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x06, 0x06, 0x06, 0x06,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x0c, 0x18, 0x30, 0x66, 0x3c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x70,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x7e, 0x7e, 0x7e, 0x7e, 0x24,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x66,
   0x00, 0x00},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x6c, 0x6c, 0x38, 0x38, 0x30,
   0x36, 0x1c},
  {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x7e,
   0x00, 0x00},
  {
   0x00, 0x70, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0c, 0x18, 0x18, 0x18, 0x18,
   0x18, 0x70},
  {
   0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
   0x18, 0x18},
  {
   0x00, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x18, 0x18, 0x18, 0x18,
   0x18, 0x0e},
  {
   0x00, 0x04, 0x7e, 0x7e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00}
};

void draw_shadow(int x1, int y1, int w, int h)
{
  int x2, y2;

  x2 = x1+w; y2 = y1+h;
  line_vga(x1, y1, x2, y1, 15, 0);
  line_vga(x1, y1, x1, y2, 15, 0);
  line_vga(x2, y1, x2, y2, 8, 0);
  line_vga(x1, y2, x2, y2, 8, 0);
}

void draw_string(int x, int y, char *str, int color, int font)
{
  int i, j, len;

  len = strlen(str);
  for(i = 0; i < len; ++i) {
    j = str[i];
    if ((j < 0x20) || (j > 0x7e)) j = 0x20;
    switch(font) {
    case 0:
      spl_bitmap(x, y, 7, 14, 14, a14xbm[j-0x20], color);
      break;
    case 1:
      spl_bitmap(x, y, 7, 14, 14, a14Bxbm[j-0x20], color);
      break;
    }
    x += 7;
  }
}

void draw_istring(int x, int y, char *str, int color, int bgcolor, int font)
{
  int i, j, len;

  len = strlen(str);
  for(i = 0; i < len; ++i) {
    j = str[i];
    if ((j < 0x20) || (j > 0x7e)) j = 0x20;
    switch(font) {
    case 0:
      set_bitmap(x, y, 7, 14, 14, a14xbm[j-0x20], color, bgcolor);
      break;
    case 1:
      set_bitmap(x, y, 7, 14, 14, a14Bxbm[j-0x20], color, bgcolor);
      break;
    }
    x += 7;
  }
}

void draw_window()
{
#ifdef notdef
  fillbox_vga(30, 28, 585, 384, 7);
  draw_shadow(30, 28, 585, 384);
  draw_shadow(36, 46, 573, 360);
  box_vga(39, 49, 566, 353, 0);
  fillbox_vga(40, 50, 565, 352, 15);
  fillbox_vga(90, 22, 159, 19, 7);
  draw_shadow(90, 22, 159, 23);
  fillbox_vga(97, 26, 146, 16, 0);
  draw_string(100, 27, "B-Free", 15, 1);
#else
  int i;

  for (i = 0; i < max_win; ++i) {
    if (w[i].map) {
      fillbox_vga(w[i].x-10, w[i].y-22, w[i].width+20,
		  w[i].height+32, 7);
      draw_shadow(w[i].x-10, w[i].y-22, w[i].width+20,
		  w[i].height+32);
      draw_shadow(w[i].x-4, w[i].y-4, w[i].width+8, w[i].height+8);
      box_vga(w[i].x-1, w[i].y-1, w[i].width+1, w[i].height+1, 15);
      fillbox_vga(w[i].x, w[i].y, w[i].width, w[i].height, 15);
      fillbox_vga(w[i].x+50, w[i].y-w[i].font_h*2,
		  w[i].font_w * 22, w[i].font_h+5, 7);
      draw_shadow(w[i].x+50, w[i].y-w[i].font_h*2,
		  w[i].font_w * 22, w[i].font_h*2-5);
      fillbox_vga(w[i].x+50+w[i].font_w, w[i].y-w[i].font_h*2+3,
		  w[i].font_w * 20, w[i].font_h+4, 0);
      draw_string(w[i].x+50+w[i].font_w+3, w[i].y-w[i].font_h*2+5,
		  w[i].title, 15, 1);
    }
  }
#endif
}
