/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/*
** gdt.c --- GDT 롼
**
*/



#include "itron.h"
#include "version.h"
#include "errno.h"
#include "task.h"
#include "func.h"



/* set_gdt --- ꤷ GDT Υȥͤ򥻥åȤ롣
 *
 * 
 *	int	index	ͤ򥻥åȤGDTΥȥؤȥ
 *	VP	desc	ǥץؤΥݥ
 *			(ǥץΤϡ8ХȤ礭)
 *
 * ֤͡
 *	顼ֹ
 *		E_OK		
 *		E_PAR	indexͤ(GDTϰϤ򥪡СƤ)
 *
 */
ER
set_gdt (int index, GEN_DESC *desc)
{
  GEN_DESC	*p;

  if ((index <= 0) || (index > MAX_GDT))
    {
      return (E_PAR);	/* ѥ᡼ */
    }
  p = (GEN_DESC *)GDT_ADDR;
  bcopy (desc, &p[index], sizeof (GEN_DESC));
  return (E_OK);
}


/* get_gdt --- ꤷ GDT ΥȥΥǥץФ
 *
 * 
 *	int	index	ͤФGDTΥȥؤȥ
 *
 * ֤͡
 *	ǻꤵ줿GDTΥȥؤΥݥ󥿡
 *
 */
GEN_DESC *
get_gdt (int index)
{
  GEN_DESC	*p;

/*  printf ("get_gdt = %d\n", index);	/* */
  if ((index <= 0) || (index > MAX_GDT))
    {
      return (NULL);	/* ѥ᡼ */
    }

  p = (GEN_DESC *)GDT_ADDR;
  return (&p[index + TSS_BASE]);
}





