function b2rStorageBbsmenu(){
	this._init();
}

b2rStorageBbsmenu.prototype = {
	_init: function(){
		var database = gStorageService.database;
		database.beginTransaction();
		try{
			if(!database.tableExists("bbsmenu")){
				let sql = <>
					CREATE TABLE bbsmenu(
					    title       TEXT NOT NULL,
					    title_n     TEXT NOT NULL,
					    url         TEXT,
					    path        TEXT NOT NULL,
					    board_type  INTEGER,
					    board_id    TEXT,
					    is_category INTEGER NOT NULL
					);
				</>.toString().replace(/\t/g, "");
				database.executeSimpleSQL(sql);
				database.executeSimpleSQL("CREATE INDEX IF NOT EXISTS bbsmenu_board_id_index ON bbsmenu(board_id);");
			}
		}catch(ex){
			Components.utils.reportError(ex);
		}finally{
			database.commitTransaction();
		}

	},


	updateBbsmenu: function(aBbsmenuFile){
		var b2rService = XPC.getService("@bbs2ch.sourceforge.jp/b2r-global-service;1", "b2rIGlobalService");
		var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");

		if(!aBbsmenuFile.exists()){
			Components.utils.reportError("b2rStorageBbsmenu.createBbsmenu() : bbsmenu.html Is Not Found");
			return;
		}

		var contentLines = b2rService.io.readFile(aBbsmenuFile, "Shift_JIS");
			// sʒȕC
		contentLines = contentLines.replace(/<\/B><BR><A HREF/igm, "</B><BR>\n<A HREF");
		contentLines = contentLines.split("\n");

		var categoryReg = /<BR><B>([^<]+)<\/B><BR>/i;
		var threadReg	= /^<A HREF=([^> ]+)>([^<]+)<\/A>/i;
		var threadReg2	= /^<A HREF=([^> ]+) TARGET=_blank>([^<]+)<\/A>/i;

		var database = gStorageService.database;
		var sql = "INSERT INTO bbsmenu(title, title_n, path, is_category) VALUES(?1, ?2, ?3, 1);";
		var categoryInsertStatement = database.createStatement(sql);
		sql = "INSERT INTO bbsmenu(title, title_n, url, path, board_type, board_id, is_category) VALUES(?1, ?2, ?3, ?4, ?5, ?6, 0);";
		var bosrdInsertStatement = database.createStatement(sql);

		database.beginTransaction();
		try{
			database.executeSimpleSQL("DELETE FROM bbsmenu");
			database.executeSimpleSQL("INSERT INTO bbsmenu(title, title_n, path, is_category) VALUES('2ch', '2ch', '/2ch/', 1);");

			var currentCategoryPath = null;
			for each(let line in contentLines){
				if(categoryReg.test(line)){
					let title = RegExp.$1;
					currentCategoryPath = "/2ch/" + title.replace(/\//g, "_") + "/";
					categoryInsertStatement.bindStringParameter(0, title);
					categoryInsertStatement.bindStringParameter(1, gStorageService._getNormarizedString(title));
					categoryInsertStatement.bindStringParameter(2, currentCategoryPath);
					categoryInsertStatement.execute();
				}else if((threadReg.test(line) || threadReg2.test(line)) && currentCategoryPath){
					let url = ioService.newURI(RegExp.$1, null, null).QueryInterface(Ci.nsIURL);
					let title = RegExp.$2;
					let path = currentCategoryPath + title.replace(/\//g, "_") + "/";
					let boardType = b2rService.threadUtils.getBoardType(url);
					bosrdInsertStatement.bindStringParameter(0, title);
					bosrdInsertStatement.bindStringParameter(1, gStorageService._getNormarizedString(title));
					bosrdInsertStatement.bindStringParameter(2, url.spec);
					bosrdInsertStatement.bindStringParameter(3, path);
					bosrdInsertStatement.bindInt32Parameter(4, boardType);
					bosrdInsertStatement.bindStringParameter(5, (boardType==5) ? "" : b2rService.threadUtils.getBoardID(url));
					bosrdInsertStatement.execute();
				}

			}
		}catch(ex){
			Components.utils.reportError(ex);
			Components.utils.reportError(gStorageService.database.lastErrorString);
		}finally{
			database.commitTransaction();
		}
	}

};
