/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


function b2rGlobalIO(){
}

b2rGlobalIO.prototype = {

	getDataDir: function(){
		const DATA_DIR_NAME = "bbs2chreader";

		if(!this._dataDir){
			var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");

				// Ot@C̈ʒuw
			if(pref.getBoolPref("extensions.bbs2chreader.appoint_data_dir")){
				try{
					var dataDirPath = pref.getComplexValue("extensions.bbs2chreader.data_dir",
												Ci.nsISupportsString).data;
					this._dataDir = XPC.createInstance("@mozilla.org/file/local;1", "nsILocalFile");
					this._dataDir.initWithPath(dataDirPath);
					if(this._dataDir.leafName != DATA_DIR_NAME){
						this._dataDir.appendRelativePath(DATA_DIR_NAME);
					}
				}catch(ex){
					dump("b2rGlobalIO.getDataDir() :" + ex +"\n");
					this._dataDir = null;
				}
			}
			if(!this._dataDir){
					// w肵ĂȂƂ̓vt@CfBNg
				var dirService = XPC.getService("@mozilla.org/file/directory_service;1", "nsIProperties");
				this._dataDir = dirService.get("ProfD", Ci.nsILocalFile);
				this._dataDir.appendRelativePath(DATA_DIR_NAME);
			}
		}

		var dataDir = this._dataDir.clone().QueryInterface(Ci.nsILocalFile);
		if(!dataDir.exists()){
			dataDir.create(Ci.nsILocalFile.DIRECTORY_TYPE, 0755);
		}
		return dataDir;
	},


	getLogFileAtURL: function(aURLSpec){
		var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");
		try{
			var fromURL = ioService.newURI(aURLSpec, null, null).QueryInterface(Ci.nsIURL);
		}catch(ex){
			throw Components.results.NS_ERROR_INVALID_ARG;
		}

		var boardID = gGlobalService.threadUtils.getBoardID(fromURL)
		return this.getLogFileAtBoardID(boardID);
	},


	getLogFileAtBoardID: function(aBoardID){
		const LOGS_DIR_NAME = "logs-050pre2";

		var logFile = this.getDataDir();
		logFile.appendRelativePath(LOGS_DIR_NAME);

		var pathArray = aBoardID.split("/");
		for(let i=0; i<pathArray.length; i++){
			if(pathArray[i]) logFile.appendRelativePath(pathArray[i]);
		}
		return logFile;
	},


	readFile: function(aLocalFile, aCharset){
		var inputStream;
		try{
			inputStream = this.getFileInputStream(aLocalFile, aCharset);
		}catch(ex){
			throw ex;
		}

		var result = new Array();
		var str = {};
		while (inputStream.readString(1024*8, str) != 0) {
			result.push(str.value);
		}
		inputStream.close();
		return result.join("");
	},


	getFileInputStream: function(aLocalFile, aCharset){
		const PR_RDONLY = 0x01;
		var charset = aCharset || "UTF-8";

		var fileInputStream = XPC.createInstance(
				"@mozilla.org/network/file-input-stream;1", "nsIFileInputStream");
		var converterInputStream = XPC.createInstance(
				"@mozilla.org/intl/converter-input-stream;1", "nsIConverterInputStream");

		try{
			fileInputStream.init(aLocalFile, PR_RDONLY, 0666, Ci.nsIFileInputStream.CLOSE_ON_EOF);
			converterInputStream.init(fileInputStream, charset, 1024*8,
					Ci.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);
		}catch(ex){
			throw Components.results.NS_ERROR_INVALID_ARG;
		}
		return converterInputStream;
	},


	getFileOutputStream: function(aLocalFile, aCharset, aAppend){
		const PR_WRONLY = 0x02;
		const PR_CREATE_FILE = 0x08;
		const PR_APPEND = 0x10;
		const PR_TRUNCATE = 0x20;

		var charset = aCharset || "UTF-8";
		var ioFlags = (aAppend==true) ? PR_WRONLY|PR_CREATE_FILE|PR_APPEND : PR_WRONLY|PR_CREATE_FILE|PR_TRUNCATE;

		var fileOutputStream = XPC.createInstance(
				"@mozilla.org/network/file-output-stream;1", "nsIFileOutputStream");
		var converterOutputStream = XPC.createInstance(
				"@mozilla.org/intl/converter-output-stream;1", "nsIConverterOutputStream");

		try{
			fileOutputStream.init(aLocalFile, ioFlags, 0666, 0);
			converterOutputStream.init(fileOutputStream, charset, 1024*8,
					Ci.nsIConverterOutputStream.DEFAULT_REPLACEMENT_CHARACTER);
		}catch(ex){
			throw Components.results.NS_ERROR_INVALID_ARG;
		}


		return converterOutputStream;
	}


};
