/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/**
 * クリップボード操作オブジェクト
 */
var Bbs2chClipboard = {

	/**
	 * クリップボードの文字列を取得する
	 * @type string
	 * @return クリップボードの文字列
	 */
	getString: function(){
		var resultStr = "";
		var clipBoard = Components.classes["@mozilla.org/widget/clipboard;1"]
								.createInstance(Components.interfaces.nsIClipboard);
		var transferable = Components.classes["@mozilla.org/widget/transferable;1"]
								.createInstance(Components.interfaces.nsITransferable);
		transferable.addDataFlavor("text/unicode");
		var transferData = {};
		try{
			clipBoard.getData(transferable, clipBoard.kGlobalClipboard);
			transferable.getTransferData("text/unicode", transferData, {});
			resultStr = transferData.value.QueryInterface(Components.interfaces.nsISupportsString);
		}catch(e){}
		return resultStr;
	},


	/**
	 * クリップボードの文字列を設定する
	 * @param {string} 文字列
	 * @type string
	 * @return 設定した文字列
	 */
	setString: function(aString){
		var copyString = new String(aString);
		var clipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
									.getService(Components.interfaces.nsIClipboardHelper);
		try{
			clipboardHelper.copyString(copyString);
		}catch(e){
			return null;
		}
		return copyString;
	}
}
