package cerot.blight.view.callstack;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JComponent;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

import cerot.blight.btrace.MethodExpression;

public class CallStackCreator {
	private Map<Integer, MethodExpression> methodMap = new HashMap<Integer, MethodExpression>();

	private DefaultCategoryDataset dataset = new DefaultCategoryDataset();

	public CallStackCreator(List<MethodExpression> methodExpressionList) {
		for (int i = 0; i < methodExpressionList.size(); i++) {
			MethodExpression methodExpression = methodExpressionList.get(i);

			long timestamp = methodExpression.getTimestamp().longValue();
			Date date = new Date(timestamp);
			String dateStr = new SimpleDateFormat("HH:mm:ss.SSS").format(date);

			this.dataset.addValue(1, Integer.valueOf(i), dateStr);
			methodMap.put(Integer.valueOf(i), methodExpression);
		}
	}

	public JComponent createComponent() {
		JFreeChart chart = ChartFactory.createStackedBarChart(
				"Method Call", "Timeline", "# of Calls", this.dataset,
				PlotOrientation.VERTICAL, false, true, false);

		ChartPanel panel = new ChartPanel(chart);
		panel.addChartMouseListener(new MyMouserListener());

		return panel;
	}

	class MyMouserListener implements ChartMouseListener {
		@Override
		public void chartMouseClicked(ChartMouseEvent event) {
			ChartEntity entity = event.getEntity();
			if (entity instanceof CategoryItemEntity == false) {
				return;
			}

			CategoryItemEntity itemEntity = (CategoryItemEntity) entity;
			MethodExpression methodExpression = methodMap.get(itemEntity
					.getRowKey());
			System.out.println(methodExpression);
		}

		@Override
		public void chartMouseMoved(ChartMouseEvent event) {
			// TODO Auto-generated method stub

		}
	}
}
