/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class mxCellEditor
implements mxICellEditor {
    public static int DEFAULT_MIN_WIDTH = 100;
    public static int DEFAULT_MIN_HEIGHT = 60;
    public static double DEFAULT_MINIMUM_EDITOR_SCALE = 1.0;
    protected mxGraphComponent graphComponent;
    protected boolean returnEnabled = false;
    protected double minimumEditorScale = DEFAULT_MINIMUM_EDITOR_SCALE;
    protected int minimumWidth = DEFAULT_MIN_WIDTH;
    protected int minimumHeight = DEFAULT_MIN_HEIGHT;
    protected transient Object editingCell;
    protected transient EventObject trigger;
    protected transient JScrollPane scrollPane;
    protected transient JTextArea textArea;
    protected transient JEditorPane editorPane;
    protected transient KeyAdapter keyListener = new KeyAdapter(){
        protected transient boolean ignoreEnter = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            if (mxCellEditor.this.returnEnabled && keyEvent.getKeyCode() == 10) {
                if (keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isAltDown()) {
                    if (!this.ignoreEnter) {
                        this.ignoreEnter = true;
                        try {
                            KeyEvent keyEvent2 = new KeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), 0, keyEvent.getKeyCode(), keyEvent.getKeyChar());
                            ((Component)keyEvent.getSource()).dispatchEvent(keyEvent2);
                        }
                        finally {
                            this.ignoreEnter = false;
                        }
                    }
                } else if (!this.ignoreEnter) {
                    mxCellEditor.this.stopEditing(false);
                }
            }
        }
    };

    public mxCellEditor(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.textArea.setOpaque(false);
        this.textArea.addKeyListener(this.keyListener);
        this.editorPane = new JEditorPane();
        this.editorPane.setOpaque(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.addKeyListener(this.keyListener);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setVisible(false);
        this.scrollPane.setOpaque(false);
    }

    public void setReturnEnabled(boolean bl) {
        this.returnEnabled = bl;
    }

    public boolean isReturnEnabled() {
        return this.returnEnabled;
    }

    public Component getEditor() {
        if (this.textArea.getParent() != null) {
            return this.textArea;
        }
        if (this.editingCell != null) {
            return this.editorPane;
        }
        return null;
    }

    public Rectangle getEditorBounds(mxCellState mxCellState2) {
        mxIGraphModel mxIGraphModel2 = mxCellState2.getView().getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(mxCellState2.getCell());
        Rectangle rectangle = null;
        if (mxGeometry2 != null && mxGeometry2.getOffset() != null && (mxGeometry2.getOffset().getX() != 0.0 || mxGeometry2.getOffset().getY() != 0.0) || mxIGraphModel2.isEdge(mxCellState2.getCell())) {
            rectangle = mxCellState2.getLabelBounds().getRectangle();
            rectangle.height += 10;
        } else {
            rectangle = mxCellState2.getRectangle();
        }
        return rectangle;
    }

    public String getInitialValue(mxCellState mxCellState2) {
        return this.graphComponent.getEditingValue(mxCellState2.getCell(), this.trigger);
    }

    public String getCurrentValue() {
        if (this.textArea.getParent() != null) {
            return this.textArea.getText();
        }
        return this.editorPane.getText();
    }

    public void startEditing(Object object, EventObject eventObject) {
        mxCellState mxCellState2;
        if (this.editingCell != null) {
            this.stopEditing(true);
        }
        if ((mxCellState2 = this.graphComponent.getGraph().getView().getState(object)) != null) {
            double d = Math.max(this.minimumEditorScale, this.graphComponent.getGraph().getView().getScale());
            JTextComponent jTextComponent = null;
            this.trigger = eventObject;
            this.editingCell = object;
            this.scrollPane.setBounds(this.getEditorBounds(mxCellState2));
            this.scrollPane.setSize(Math.max(this.scrollPane.getWidth(), (int)Math.round((double)this.minimumWidth * d)), Math.max(this.scrollPane.getHeight(), (int)Math.round((double)this.minimumHeight * d)));
            this.scrollPane.setVisible(true);
            if (this.graphComponent.getGraph().isHtmlLabel(object)) {
                this.editorPane.setDocument(mxUtils.createHtmlDocument(mxCellState2.getStyle(), d));
                this.editorPane.setText(mxUtils.getBodyMarkup(this.getInitialValue(mxCellState2), true));
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setOpaque(false);
                jPanel.add((Component)this.editorPane, "Center");
                this.scrollPane.setViewportView(jPanel);
                jTextComponent = this.editorPane;
            } else {
                this.textArea.setFont(mxUtils.getFont(mxCellState2.getStyle(), d));
                Color color = mxUtils.getColor(mxCellState2.getStyle(), mxConstants.STYLE_FONTCOLOR, Color.black);
                this.textArea.setForeground(color);
                this.textArea.setText(this.getInitialValue(mxCellState2));
                this.scrollPane.setViewportView(this.textArea);
                jTextComponent = this.textArea;
            }
            this.graphComponent.getGraphControl().add((Component)this.scrollPane, 0);
            this.graphComponent.redraw(mxCellState2);
            jTextComponent.revalidate();
            jTextComponent.requestFocusInWindow();
            jTextComponent.selectAll();
        }
    }

    public void stopEditing(boolean bl) {
        if (this.editingCell != null) {
            this.scrollPane.transferFocusUpCycle();
            Object object = this.editingCell;
            this.editingCell = null;
            if (!bl) {
                EventObject eventObject = this.trigger;
                this.trigger = null;
                this.graphComponent.labelChanged(object, this.getCurrentValue(), eventObject);
            } else {
                mxCellState mxCellState2 = this.graphComponent.getGraph().getView().getState(object);
                this.graphComponent.redraw(mxCellState2);
            }
            if (this.scrollPane.getParent() != null) {
                this.scrollPane.setVisible(false);
                this.scrollPane.getParent().remove(this.scrollPane);
            }
            this.graphComponent.requestFocusInWindow();
        }
    }

    public Object getEditingCell() {
        return this.editingCell;
    }

    public double getMinimumEditorScale() {
        return this.minimumEditorScale;
    }

    public void setMinimumEditorScale(double d) {
        this.minimumEditorScale = d;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int n) {
        this.minimumHeight = n;
    }
}

