-- Parameters to vary --
degree = 12
poly_space = 'Q'
-- ...the uniform refinement level for the periodic cube

logging = { level = 3 }
-- Check for Nans and unphysical values
check =  { interval = 1 }

-- ...the general projection table
projection = {
  kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
  factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
}

--...Configuration of simulation time
sim_control = { 
  time_control = { 
    max = {iter = 1},  -- final Simulated time
    min = 0.0, 
    interval = {iter = 1} 
  }
}

restart = {
--  read = './restart/simulation_lastHeader.lua',
  write = './restart/',
  time_control = { 
    max = {iter = 30},
    min = 0,
    interval = {iter = 10}
  },
}
-- Mesh definitions --
cubeLength = 4.0
mesh = './mesh/' 
--weights = './test2_weights.lsb'
write_weights = './test_weights'

-- Tracking              
tracking = {
  label = 'track_density',
  folder = './',
  variable = {
    'density', 
    'full_density', 
  },
  shape = {
    kind = 'canoND', 
    object= {
      origin = {-1.0,0.0,0.0}, 
    }
  },
  time_control = { 
    max = sim_control.time_control.max,  -- final Simulated time
    min = 0,
    interval = {iter = 1}
  },
  output = { 
    format = 'ascii', use_get_point = true 
  }
}

bg_dens = 1.225
bg_velX = 100.0
bg_velY = 0.0
bg_velZ = 0.0
bg_press = 100000.0

variable = {
  -- add the background to varSys
  {
    name = 'bg_density',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun =  bg_dens,  
  },
  {
    name = 'full_density',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'addition',
      input_varname = {'density','bg_density'},
    }          
  },
}  

-- Equation definitions --
equation = {
  name   = 'linearEuler',
  numflux = 'godunov', 
  isen_coef = 1.4,
  background = {
    density = bg_dens, 
    velocityX = bg_velX,
    velocityY = bg_velY,
    velocityZ = bg_velZ,
    pressure = bg_press
  }
}

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
    m =  degree,                   -- the maximal polynomial degree for each spatial direction
    modg_space = poly_space
  }, 
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitRungeKutta', 
    steps = 4,
    control = {
      name = 'cfl',   -- the name of the timestep control mechanism
      cfl  = 0.95,     -- CourantÐFriedrichsÐLewy number
    },
  },
}

-- variables for gaussian pluse             
c = math.sqrt(equation.isen_coef* equation.background.pressure / equation.background.density)
ampl_density= equation.background.density/c 
ampl_pressure= equation.background.pressure/c 

function init_density(x,y,z)
if x<0 then
  return(0.0)
else
  return(1.0)
end
end

function ic_gauss_density(x,y,z)
d= x*x+y*y+z*z 
return( ampl_density * math.exp(-d/0.01*math.log(2)) )
end

function ic_gauss_pressure(x,y,z)
d= x*x+y*y+z*z
return( ampl_pressure * math.exp(-d/0.01*math.log(2)) )
end

-- Initial Condition definitions --
initial_condition = { density = ic_gauss_density,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                      pressure = 0.0 --ic_gauss_pressure, 
                    }
 -- Boundary definitions
 boundary_condition = {
  {
    label = 'wall_1',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'wall_2',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'wall_3',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'wall_4',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'wall_5',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
  ,
  {
    label = 'wall_6',
    kind = 'primitives',
    density = 0.0,
    velocityX = 0.0,
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = 0.0,
  }
}
