#!/bin/sh
# Run Musubi with different number of processes and check the restart file, 
# if it is identical by using the checksum (md5sum)
# We run the code for a set of defined processes (procs)
# and check the md5sum of the restart files
# by default this script checks last restart write and read files 
# i.e files written at tmax in config file


executable='EXEC'
#executable=../../../build/debug/ateles

restart_write_folder='restart/write/'
restart_read_folder='restart/read/'

procs='1 4 7'
config='maxwell_periodic_modg'

error=0
errorCount=0


# execute for all procs
for CONFIG in $config; do
  for NPROCS in $procs; do

    echo "Running ${CONFIG}_${NPROCS}"

    # execute ateles_write.lua and ateles_read.lua for all procs (WRITE md5 sums)
    # generate restart WRITE md5 sums
    rm -rf  ${restart_write_folder} ${restart_read_folder}
    mkdir -p ${restart_write_folder}


    # run ateles
    CONFIG="$CONFIG" NPROCS="$NPROCS" mpirun -np ${NPROCS} ${executable} ateles_write.lua 
    errorcode=$?
    if [ $errorcode -ne 0 ]; 
    then 
      echo "$(tput setaf 1)Error$(tput sgr0): ateles returned with status $errorcode"
      exit 
    fi


    #file name to store md5sum output from restart write
    sumname=restart/write_${CONFIG}_${NPROCS}.md5

    echo 'Storing restart write md5sum to ' $sumname
    md5sum ${restart_write_folder}/*10.000E-03.lsb > ${sumname}


    # generate restart READ md5 sums
    mkdir -p ${restart_read_folder}

    # run ateles
    CONFIG="$CONFIG" NPROCS="$NPROCS" mpirun -np ${NPROCS} ${executable} ateles_read.lua 
    errorcode=$?
    if [ $errorcode -ne 0 ]; 
    then 
      echo "$(tput setaf 1)Error$(tput sgr0): ateles returned with status $errorcode}"
      exit 
    fi

    #file name to store md5sum output from restart read
    sumname=restart/read_${CONFIG}_${NPROCS}.md5

    echo 'Storing restart read md5sum to ' $sumname
    md5sum ${restart_read_folder}/*10.000E-03.lsb > ${sumname}



    tail -1 restart/write_${CONFIG}_${NPROCS}.md5 | awk '{print $1}' > restart/lastLine_write
    tail -1 restart/read_${CONFIG}_${NPROCS}.md5 | awk '{print $1}' > restart/lastLine_read

    echo  "Now testing difference in the last line between WRITE ${NPROCS}procs and READ/WRITE ${NPROCS}procs:"
    difference=`diff restart/lastLine_write restart/lastLine_read`
    if [ "X$difference" = "X" ]; then
      echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
    else
      error=1
      errorCount=`expr $errorCount + 1`
      echo "$(tput setaf 1)Error$(tput sgr0): Difference found between ${nprocs} Write and Read/Write:" 
      echo ${difference}
    fi
  done
done

rm restart/lastLine*

if [ "$errorCount" = "0" ]; then
  echo Done. Everything $(tput setaf 2)OK$(tput sgr0)
  exit 0 
else
  echo Done. $(tput setaf 1)$errorCount errors$(tput sgr0) occured. >&2
  exit 1
fi

