require 'common'

logging = { level = 10 }

-------------------------------------------
degree = 15
dt = 1.5e-5
--track_name = './track/'
-------------------------------------------
-- global simulation options
simulation_name='ateles_right'
sim_control = {
  time_control = {
    min = 0,
    max = { iter = 11010 },
    interval = { iter = 1 }
  }
}

-- table for preCICE
-- table for preCICE
-- When using RK2, we also have the possibility to exchange data during the
-- intermdeiate timestep, therefore the option "use_RK2_inter" should be set
-- to true.
precice = {
  accessor = 'Ateles_right',
  configFile ='precice_config.xml',
  --use_RK2_inter = true,
}
-- Restart settings
restart = {
  --read = './restart/right/ateles_right_lastHeader.lua',
  write = './restart/right/',
  time_control = {
    min = 0,
    max = { iter = 11000 },
    interval = { iter = 1000 }
  }
}

-- for the spacetime-function kind=precice, there exist now several option for
-- the interpolation. when setting:
-- make use of equidistant points:
-- 1. use_eq_points = true
-- set how many points should be created for write to precice, by default this
-- variable is set to 1, thus the number of points is equal to the scheme order.
-- the factor is always multiplied by the scheme order, which results in the
-- total number of points per face.
-- 2. factor_eq_points = 1
-- using nearest-projection with nonequidistant points:
-- 3. use_np = true
-- using equidistant points and nearest-projection:
-- 4. use_eq_points = true
--    use_np = true
--    factor_eq_points = <number>
-- remember: with the new implementation two meshids are needed for precice, thus
-- one for read and one for write.
-- 5. if nothing is set (every logical statement is false), just the
-- non-equidistant points are considered


characteristic = 0.0
relax_temperature = 0.0
relax_velocity = { 0.0, 0.0 }

-- Variable system definintion--
variable = {
  -- This is the global material for Euler 3D. It consists of three different
  -- components, characteristics with one scalar, relax_velocity with three
  -- scalars and relax_temperature with one scalar, thus we need five scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a
  -- neutral term, which in this case is 0.
  {
    name = 'characteristic',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = characteristic
  },
  {
    name = 'relax_velocity',
    ncomponents = 2,
    vartype = "st_fun",
    st_fun = relax_velocity
  },
  {
    name = 'relax_temperature',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = relax_temperature
  },
  {
    name = 'ref_density',
    ncomponents = 1,
    vartype ='st_fun',
    st_fun = gauss,
  },
  {
    name = 'error',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = { 'density', 'ref_density' },
    }
  },
  {
    name = 'coupling',
    ncomponents = 4,
    vartype = 'st_fun',
    st_fun = {
      predefined = 'precice',
      use_EQ_points = true,
      use_NP = true,
      factor_EQ_points = 3 ,
      precice_meshWrite = 'rightSurface_Write',
          write_varname = { 'Density_right',
                            'MomX_right',
                            'MomY_right',
                            'Energy_right'
      },
      precice_meshRead = 'rightSurface_Read',
          read_varname = { 'Density_left',
                           'MomX_left',
                           'MomY_left',
                           'Energy_left'
      }
    }
  },
  --write to precice
  {
    name = 'Density_right',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'density',
      input_varindex = { 1 }
    }
  },
  {
    name = 'MomX_right',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'momentum',
      input_varindex = { 1 }
    }
  },
  {
    name = 'MomY_right',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'momentum',
      input_varindex = { 2 }
    }
  },
  {
    name = 'Energy_right',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'energy',
      input_varindex = { 1 }
    }
  },
  --read from precice
  {
    name = 'Density_left',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling',
      input_varindex = { 1 }
    }
  },
  {
    name = 'MomX_left',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling',
      input_varindex = { 2 }
    }
  },
  {
    name = 'MomY_left',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling',
      input_varindex = { 3 }
    }
  },
  {
    name = 'Energy_left',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'extract',
      input_varname = 'coupling',
      input_varindex = { 4 }
    }
  }
}

-- Mesh definitions --
mesh = '../mesh_right/'

-- timing settings (i.e. output for performance measurements, this table is otional)
timing_file = 'timing_right.res'         -- the filename of the timing results

-- Equation definitions --
equation = {
  name = 'euler_2d',
  therm_cond = 2.555e-02,
  isen_coef = 1.4,
  r = 296.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg_2d',
    modg_space = 'Q',
    m = degree
  },
  --stabilization = {
  --  name = 'spectral_viscosity',
  --  alpha = 36,
  --  order = filter_order,
  --},
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitSSPRungeKutta',
    steps = 2,
    control = {
      name = 'fixed',
      dt = dt
    }
  }
}

-- Initial condition
initial_condition = {
  density = dens,
  pressure = press,
  velocityX = velocityX,
  velocityY = 0.0
}

 -- Boundary definitions
boundary_condition = {
  {
    label = 'west',
    kind = 'conservatives',
    density = 'Density_left',
    momentumX = 'MomX_left',
    momentumY = 'MomY_left',
    energy = 'Energy_left',
  }
  ,
  {
    label = 'east',
    kind = 'outflow',
    pressure = press,
  }
  ,
  {
    label = 'north',
    kind = 'primitives',
    density = dens,
    velocityX = velocityX,
    velocityY = 0.0,
    pressure = press,
  }
  ,
  {
    label = 'south',
    kind = 'primitives',
    density = dens,
    velocityX = velocityX,
    velocityY = 0.0,
    pressure = press,
  }
  ,
  {
    label = 'top',
    kind = 'primitives',
    density = dens,
    velocityX = velocityX,
    velocityY = 0.0,
    pressure = press,
  }
  ,
  {
    label = 'bottom',
    kind = 'primitives',
    density = dens,
    velocityX = velocityX,
    velocityY = 0.0,
    pressure = press,
  }
}
