-- physical setup--------------------------------------------------------------
dens = 1.0
velocityX = 0.0
velocityY = 0.0
press = 10.0
function gauss_dens (x,y,z)
  d= (x)*(x)+y*y
  return( dens + 1.0* math.exp(-d/0.02*math.log(2)) )
end
function gauss_press (x,y,z)
  d= (x)*(x)+y*y
  return( press + 5.0* math.exp(-d/0.02*math.log(2)) )
end
-- common simulation controll parameter----------------------------------------
timestep_info = 1

logging = {level=1}

check =  {interval = 1}
tmax = 2.0
sim_control = {
             time_control = {
                  min = 0,
                  max = tmax,
                  interval = {iter = 100}, -- final simulation time
                }
}

-- output ---------------------------------------------------------------------
track_dt = 0.05

-- Simulation parameter -------------------------------------------------------
degree = 3
scheme = {
  spatial =  {
    name = 'modg_2d',
    modg_space = 'Q',
    m = degree,
  },
--  stabilization = {
--    name = 'spectral_viscosity',
--    alpha = 36,
--    order = filter_order,
--  },
  temporal = {
    name = 'explicitSSPRungeKutta',
    steps = 2,
    control = {
      name = 'cfl',
      cfl  = 0.2,
      cfl_visc  = 0.2,
    },
  },
}
projection = {
  kind = 'l2p',
  factor = 1.0,
}
