require 'common'
-- physical parameter ---------------------------------------------------------
initial_condition = {
  density = dens, 
  velocityX = velocityX,
  velocityY = velocityY,
  pressure = press, 
}

-- simulation controll parameter-----------------------------------------------
simulation_name='ateles_euler'
timing_file = 'timing_euler.res'

restart = {
  read  = './restart/euler/ateles_euler_header_200.000E-03.lua',
  write = './restart/euler/',
  time_control = {
    min = 0, 
    max = tmax, 
    interval = track_dt
  },
}

-- Tracking -------------------------------------------------------------------
NOtracking = {
  { -- GLobal VTK
    label = 'global',
    folder = './track/euler/',
    variable = {'density', 'momentum', 'energy', 'velocity', 'pressure', 
                'grad_density', 'grad_velocity', 'grad_pressure' },
    shape = {
      { kind = 'all',}
    },
    time_control = {min = 0, max = tmax, interval = track_dt},
    output={format = 'vtk'},
  },
}

-- Simulation parameter -------------------------------------------------------
mesh = 'mesh_euler/'

-- Variable system definintion-------------------------------------------------
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  {
    name = 'characteristic',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = characteristic,
  },
  {
    name = 'relax_velocity',
    ncomponents = 2,
    vartype = "st_fun",
    st_fun = relax_velocity,
  },
  {
    name = 'relax_temperature',
    ncomponents = 1,
    vartype = "st_fun",
    st_fun = relax_temperature,
  },
  {
    name = 'grad_velocity',
    ncomponents = 4,
    vartype = 'operation',
    operation = {
      kind = 'gradient',
      input_varname = 'velocity',
    }          
  },
}

-- Equation definitions -------------------------------------------------------
penalization_eps = 8.0/(degree+1)
penalization_alpha = 1.0
equation = {
  penalization = {
    global = {
      kind = 'const',
      const = {0.0, 0.0, 0.0, 0.0},
    },
  },
  name       = 'euler_2d',
  isen_coef  = 1.4,
  r          = 280.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


 -- Boundary definitions
boundary_condition = {
  {
    label = 'acoustic',
    kind = 'outflow',
    pressure = press
  }
  ,
  {
    label = 'fluid',
    kind = 'outflow',
    pressure = press
  }
}
