-- Use this file as template. Do not modify this file for running some testcases

outputname = 'acoustic'
outputpreview = true 
folder = 'mesh_acoustic_2d/'

max_num_y=18
y=15 --18
x=6
dx=y/max_num_y

nLength_bnd = max_num_y+2
--minlevel = math.ceil(math.log(nLength_bnd)/math.log(2))
--cubeLength = (2^minlevel)*dx
minlevel = 9
cubeLength = 32

--maxlevel = 5
--flowlevel=6

--cubeLength = 44.8
--flow_elemsize = 0.35 
elemsize = cubeLength/(2^minlevel)

--debug = { debugMode = true, debugMesh = 'debug/' }
-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 --origin = { -elemsize, -cubeLength/(-2.0), -elemsize },
                 --origin = { -elemsize, -28*elemsize, -elemsize },
                 origin = { -elemsize, cubeLength/(-2.0),cubeLength/(-2.0) },
                 --origin = {-flow_elemsize,cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

geom_level=minlevel
epslevel = minlevel+2
--plate_level = minlevel

-- smallness parameter
eps = bounding_cube.length/(2^epslevel)

-- the element size around the plate
--smalleps = bounding_cube.length/(2^plate_level)

-- the element size of the largest elements (belonging to minlevel)
largeeps = bounding_cube.length/(2^minlevel)

spatial_object = 
                {
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = { 
                                   {
                                   kind = 'canoND',
                                   object =  
                                            {
                                            --   origin = {elemsize,-3*elemsize,1-eps},
                                            --   vec= {
                                            --          {0.0,cubeLength,0.0},
                                            --        },
                                            --  -- origin = {eps, -3.0, cubeLength-eps},
                                            origin = {elemsize, -1.0, eps},
                                            --origin = {elemsize, -3*elemsize, eps},

                                            },
                                 },
                                   {
                                   kind = 'canoND',
                                   object =  
                                            {
                                            --   origin = {elemsize,-3*elemsize,1-eps},
                                            --   vec= {
                                            --          {0.0,cubeLength,0.0},
                                            --        },
                                            --  -- origin = {eps, -3.0, cubeLength-eps},
                                            --origin = {elemsize, 6*elemsize, eps},
                                            origin = {elemsize, 4.0, eps},

                                            },
                                 },
                           }
                  },
                  -- eastern acoustic bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_East',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                    {
                                     vec= {
                                            {0.0,y+2*eps,0.0},
                                            {0.0,0.0,elemsize-2*eps},
                                          },
                                     origin={
                                               -eps,
                                               -6-eps, ---6*elemsize-eps,
                                               eps,
                                            },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_West',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                   {0.0,y+2*eps,0.0},
                                                   {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                   x+eps,
                                                   -6-eps, ---6*elemsize-eps,
                                                   eps},
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_South',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {x+2*eps,0.0,0.0},
                                                  {0.0, 0.0, elemsize-2*eps},
                                                },
                                           origin={
                                                   -eps,
                                                   -6-eps, -- -6*elemsize-eps,
                                                   -eps,
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_North',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {x+2*eps,0.0,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                   -eps,
                                                   9+eps, --9*elemsize+eps,
                                                   -eps,
                                                  },
                                          },
                              }
                  },
                  -- the euler box inside
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'euler',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {6-2*eps,0.0,0.0},
                                                  {0.0,3-2*eps,0.0},
                                                  {0.0,0.0,elemsize},
                                                  --  {6*elemsize-2*eps,0.0,0.0},
                                                  --  {0.0,3*elemsize-2*eps,0.0},
                                                  --  {0.0,0.0,elemsize},
                                                },
                                           origin={
                                                   eps,
                                                   eps,
                                                   0.0,
                                                  },
                                          },
                              }
                  },
               --boundary in z direction
                 {
                  attribute = {
                                kind = 'boundary',
                                label = 'wallBottom',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'canoND',
                                object = 
                                         {
                                            vec= {
                                                   {x,0.0,0.0},
                                                   {0.0,y,0.0},
                                                 },
                                            origin={0.0,-6.0,-eps},
                                            --origin={0.0,-6*elemsize,-eps},
                                         }
                              }
                 },
                 {
                  attribute = {
                                kind = 'boundary',
                                label = 'wallTop',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'canoND',
                                object =
                                        {
                                          vec= {
                                                   {x,0.0,0.0},
                                                   {0.0,y,0.0},
                                               },
                                            origin={0.0,-6.0,elemsize+eps},
                                            --origin={0.0,-6*elemsize,elemsize+eps},
                                         },
                              }
                 },
                }

	    
