-- Configuration file for Ateles --
require 'seeder_2d_acoustic'

filter_order = 14
degree = 16

-- global simulation options
simulation_name = 'jet_acoustic_modg'
sim_control = {
              time_control  = {
                                min = 0.0,
                                max = {iter=100000}, 
                                interval = { iter=1000 },
                              },
             }

logging = { level = 10 }

check = {
          interval = 1,
        }

logging = { level = 5 }

--...Info for precice
precice = {
           accessor = 'Ateles_acoustic',
           configFile ='precice_config_new.xml',
          }

-- Mesh definitions --
mesh = './mesh_acoustic_2d/'


-- Restart settings
restart = { 
--            read = './restart_medium/acoustic/jet_acoustic_modg_header_6.500E-03.lua',
            write = './restart_medium/acoustic/',                                        
            time_control = {   
                             min = 0, 
                             max = {iter=sim_control.time_control.max.iter}, 
                             interval = {iter= 10 }, --sim_control.time_control.max.iter/50},
                           },  
          }

-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
-- The ambient medium
press = 1
dens = 1
equation = {
             name   = 'acoustic_2d',
             background = {
                 density = dens, 
                 velocityX = 0.0,
                 velocityY = 0.0,
                 pressure = press
                 }
           }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
                  name = 'modg_2d',            -- we use the modal discontinuous Galerkin scheme 
                  m = degree,  --82,        -- the maximal polynomial degree for each spatial direction
               }, 
               
   -- stabilization = {
   --                   {
   --                       name = 'spectral_viscosity',
   --                       alpha = 36,
   --                       order = filter_order,
   --                    },
   --                    {
   --                        name = 'covolume',
   --                        alpha = 36,
   --                        order = filter_order,
   --                        beta = 1.0 - 2.0/(scheme.spatial.m+1),
   --                    },
   --                  },
--    stabilization = {
--                      {
--                       name = 'spectral_viscosity',
--                       alpha = 36,
--                       order = 10,
--                      },
--                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitSSPRungeKutta', 
               steps = 2,
               control = {
                          name = 'cfl', 
                          cfl  = 0.6, 
                         },
               },
}


---- the Mach number of the jet
--mach = 0.4
--
---- the velocity amplitude in z direction
--velAmpl = mach*math.sqrt(equation.isen_coef*press/dens) -- 0.1
--densAmpl = 2.0
--
--
---- the radius of the jet
--jet_radius = 0.1
--jet_center = 6.00+1e-4
----jet_center = 1e-4
--momentum_thickness = jet_radius/20
--
--function velX_inlet(x,y,z,t)
--  r = math.sqrt( (y-jet_center)*(y-jet_center) )
--  return velAmpl * (1/2) * ( 1 +  math.tanh((jet_radius-r)/(2*momentum_thickness) ) )
--end 
--
--function dens_inlet(x,y,z,t)
--  tmpVel = velX_inlet(x,y,z,t)/velAmpl
--  return densAmpl / ( 1 + (equation.isen_coef-1)/2*mach*mach*tmpVel*(1-tmpVel)  )
--end


--TODO -- random number for x and y velocity at initial time 
--TODO math.randomseed(1234)
--TODO function velXYIni(x,y,z)
--TODO   r = math.sqrt( x*x + y*y )
--TODO   return velAmpl * 1e-06 * math.exp( (-3/jetwidth) * r ) * ( math.tanh( -D * ( z - minzcoord) ) + 1.0 ) * math.random()
--TODO end

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = 0.0,
                      pressure = 0.0,
                      velocityX = 0.0,
                      velocityY = 0.0,
                    }

-- ...the general projection table
projection = {
              kind = 'fpt',  
              factor = 1.0,          
           --   lobattoPoints=true,
             }


-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'euler',  
                       kind = 'precice',
                       precice_mesh = 'AcousticSurface',
                       exchange_data_write =  {'Density_acoustic', 
                                               'Vel_X_acoustic', 
                                               'Vel_Y_acoustic', 
                                               'Pressure_acoustic' 
                                               },
                       exchange_data_read =  {'Density_euler', 
                                              'Vel_X_euler', 
                                              'Vel_Y_euler' } 
                       
                       },
                       { 
                       label = 'acoustic_East',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_West',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_South',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_North',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'wallTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'wallBottom', 
                       kind = 'slipwall',       
                       }
                     }  
precice_write = {  label = {'euler' }}
--source = {
--  spongeLayer = {
--    shape = {
--      kind = 'canoND', 
--      object= {
--        origin = { x - 4 * dx + eps, -eps, -eps },
--        vec = {
--          { 4 * elemsize, 0, 0 },
--          { 0, y, 0 },
--          { 0, 0, elemsize }
--        },
--        segments = { 400, 400, 12 }
--      } 
--    },
--    kind = 'combined',
--    spatial = { 
--      predefined = 'spongeLayer_2d', 
--      plane_origin = {x-4*dx,0.0,0},
--      --plane_origin = {bounding_cube.length-3*elemsize,0.0,0},
--      plane_normal = {1.0,0,0},
--      damp_factor = 50,
--      damp_exponent = 2,
--      target_state = {
--        density = dens,
--        velx = 0.0,
--        vely = 0.0,
--        pressure = press
--      }
--    }
--  }
--}
--debug = { 
--         debugMode = true,        -- default= false
--         verbose = 3,             -- default= 0
--
--         -- Use a logging object to track output in individual files.
--         -- The output messages to this logging object are usually
--         -- generated by tem_debug calls.
--         logging = { level = 1, -- how detailed should the log be?
--                     filename = 'dbg', -- to which file to write the log
--                     root_only = false }, -- should only root write msgs?
--
--         debugFiles = true,       -- default= false
--         -- What to dump into debugFiles? --
--        --   dumpTreeIDs = true,      -- default= false
--        --   dumpPropBits = true,     -- default= false
--        --   dumpAuxLists = true,     -- default= false
--        --   dumpDependencies = true, -- default= false
--        --   dumpState = true,        -- default= false
--        --   dumpHaloState = true,    -- default= false
--        -- --  end debugFiles  --
--        -- debugDependencies = true, -- default= false
--        -- checkDependencies = true, -- default= false
--        -- checkNans = true,         -- default= false
--        -- checkSteps = true,        -- default= false
--        -- debugMesh = 'dbg/mesh_',  -- default= ''
--        -- debugSource = true,       -- default= false
--        -- debugRestart = true,      -- default= false
--        -- traceMemory = true,       -- default= false
--        }
