-- Use this file as template. Do not modify this file for running some testcases

outputname = 'jet'
outputpreview = true 
folder = 'mesh_2d_multi2/'

-- ATTENTION: the minimum is 3, otherwise you won't get any fluid element.

max_num_y=36
y=12
x=12
dx=y/max_num_y
y_refine1=16*dx
y_refine2=6*dx

nLength_bnd = max_num_y+2
minlevel = math.ceil(math.log(nLength_bnd)/math.log(2))
cubeLength = (2^minlevel)*dx
--cubelength = nLength_bnd *dx


-- the finner level
finelevel = minlevel+1
finestlevel = minlevel+2
epslevel = minlevel+4
--
--cubeLength = 22.4
--debug = { debugMode = true, debugMesh = 'debug/' }

-- the largest element
elemsize = cubeLength/(2^minlevel)
fine_elemsize = cubeLength/(2^finelevel)
finest_elemsize = cubeLength/(2^finestlevel)
--elemsize_finest = cubeLength/(2^finestlevel)
--elemsizeSmall = cubeLength/(2^epslevel)

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {-dx,-dx,-dx},
                 length = cubeLength,
                }

-- smallness parameter
eps = bounding_cube.length/(2^(epslevel+3))

-- the diameter of the jet
jetwidth = cubeLength/40

spatial_object = 
                {

                  -- west inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflowWest',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0, y+2*eps,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                   -eps,
                                                   -eps,
                                                   eps},
                                          },
                              }
                  },
                  -- east outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowEast',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,y+2*eps,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                     x+eps,
                                                     -eps,
                                                     eps,
                                                  },
                                          },
                              }
                  },
                  {
                   attribute = {
                                 kind = 'refinement',
                                 label = 'refinement_outer',
                                 level= finelevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {  
                                                  {x-2*eps,0.0,0.0},
                                                  {0.0,y_refine1-fine_elemsize/2,0.0},
                                                  --{0.0,10*elemsize-elemsize/2,0.0},
                                                },
                                           origin={ --0.0, -0.875, 0.0},
                                                   eps,
                                                   10*dx+eps, --y_refine1/2+fine_elemsize/2,
                                                   eps},
                                                    },
                                          },
                  },

                  {
                   attribute = {
                                 kind = 'refinement',
                                 label = 'refinement_inner',
                                 level= finestlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {  
                                                  {x-2*eps,0.0,0.0},
                                                  {0.0,y_refine2-finest_elemsize/2,0.0},
                                                  {0.0,0.0,dx-eps},
                                                },
                                           origin={ --0.0, -0.875, 0.0},
                                                   eps,
                                                   15*dx+eps, --y_refine2/2+finest_elemsize/2,
                                                   eps},
                                                    },
                                          },
                  },
                  -- north outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowNorth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {x+2*eps,0.0,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                    -eps,
                                                    y+eps,
                                                    -eps
                                                  },
                                          },
                              }
                  },
                  -- south outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowSouth',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {x+2*eps,0.0,0.0},
                                                  {0.0,0.0,elemsize-2*eps},
                                                },
                                           origin={
                                                   -eps,
                                                   -eps
                                                   -eps
                                                  },
                                          },
                              }
                  },

                 -- periodic in z-direction
                 {
                  attribute = {
                                kind = 'boundary',
                                label = 'wallBottom',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'canoND',
                                object = 
                                         {
                                            vec= {
                                                   {x,0.0,0.0},
                                                   {0.0,y,0.0},
                                                 },
                                            origin={0.0,0.0,-eps},
                                         }
                              }
                 },
                 {
                  attribute = {
                                kind = 'boundary',
                                label = 'wallTop',
                                level = minlevel,
                              },
                  geometry = {
                                kind = 'canoND',
                                object =
                                        {
                                          vec= {
                                                   {x,0.0,0.0},
                                                   {0.0,y,0.0},
                                               },
                                            origin={0.0,0.0,elemsize+eps},
                                         },
                              }
                 },

                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {4*elemsize,elemsize,elemsize/2 },
                                           --origin = {bounding_cube.length/2,0.0,0.0 },
                                        },
                             },
                  },
                }
	    
