-- Configuration file for Ateles --
require 'seeder_acoustic'
degree=3
logging={level=10}

-- global simulation options
simulationname = 'gauss_acoustic_modg'             -- the name of the simualtion
sim_control = {
              time_control  = {
                                min = 0.0,
                                max = {iter=1000},                  -- final simulation time
                                interval = {iter=100},
                              },
             }

check = {
          interval = 100,
        }

--...Info for precice
precice = {
           accessor = 'Ateles_acoustic',
           configFile ='precice_config.xml',
          }


-- Mesh definitions --
mesh = './mesh_acoustic/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/acoustic/',                                        
            -- temporal definition of restart write
            time_control = {   
                            min = 0, 
                            max = {iter=sim_control.time_control.max.iter},  
                            interval = {iter=500}
                           },  
          }


-- the filename of the timing results i.e. output for performance measurements
timing_file = 'timing.res'        

-- Equation definitions --
equation = {
             name   = 'acoustic',
             background = {
                 density = 1.225, 
                 velocityX = 0.0,
                 velocityY = 0.0,
                 velocityZ = 0.0,
                 pressure = 100000.0
                 }
           }

check = {
          interval = 100,
        }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m = degree,
               }, 
    -- the temporal discretization scheme
    temporal = {
                name = 'explicitSSPRungeKutta',  -- we use ssp explicit runge kutta in time
                steps = 2,                       -- we have a 2 stage
                control = {                      -- how to control the timestep
                           name = 'cfl',         -- the name of the timestep control mechanism
                           cfl = 0.8            -- Courant Friedrichs Lewy number
                          }
               }
}


-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = 0.0, 
                      pressure = 0.0,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                    }


-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'euler',  
                       kind = 'precice',
                       precice_mesh = 'AcousticSurface',
--                       provide_mesh = true,
                       exchange_data_write =  {'Density_acoustic', 
                                               'Vel_X_acoustic', 
                                               'Vel_Y_acoustic', 
                                               'Vel_Z_acoustic',  
                                               'Pressure_acoustic' 
                                               },
                       exchange_data_read =  {'Density_euler', 
                                              'Vel_X_euler', 
                                              'Vel_Y_euler', 
                                              'Vel_Z_euler'}
                       
                       },
                       { 
                       label = 'acoustic_East',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_West',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_South',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_North',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_Bottom',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                       { 
                       label = 'acoustic_Top',  
                       kind = 'outflow',       
                       density = extrapolte,
                       }
                       ,
                     }  

precice_write = {  label = {'euler'}}
