-- Use this file as template. Do not modify this file for running some testcases

outputname = 'plate'
outputpreview = true 
folder = 'mesh_ateles/'

level = 5

cubeLength = 8.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }


-- the element size of the largest elements (belonging to minlevel)
eps = bounding_cube.length/(2^level+1)

spatial_object = 
                {
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {-2.0+eps, -2.0+eps, -2.0+eps},

                                        },
                             },
                  },
                  -- eastern acoustic bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_East',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    2.0+eps, 
                                                   -2.0-eps, 
                                                   -2.0-eps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_West',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -2.0-eps, 
                                                   -2.0-eps, 
                                                   -2.0-eps,
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_South',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -2.0-eps, 
                                                   -2.0-eps, 
                                                   -2.0-eps,
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_North',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   -2.0-eps, 
                                                   2.0+eps, 
                                                   -2.0-eps,
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Bottom',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                   -2.0-eps, 
                                                   -2.0-eps, 
                                                   -2.0-eps,
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'acoustic_Top',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                   -2.0-eps, 
                                                   -2.0-eps, 
                                                   2.0+eps,
                                                  },
                                          },
                              }
                  },
                  -- eastern inflow bnd
--                  {
--                   attribute = {
--                                 kind = 'boundary',
--                                 label = 'acoustic_outer',
--                                 level = level,
--                               },
--                   geometry = {
--                                 kind = 'canoND',
--                                 object = 
--                                          {
--                                           only_surface = true,       -- Use only surface of the object?
--                                           vec= {
--                                                  {bounding_cube.length,0.0,0.0},
--                                                  {0.0,bounding_cube.length,0.0},
--                                                  {0.0,0.0,bounding_cube.length},
--                                                },
--                                           origin={
--                                                   -2.0-eps,
--                                                   -2.0-eps,
--                                                   -2.0-eps,
--                                                  --   (-1)*bounding_cube.length/2+largeeps,
--                                                  --   (-1)*bounding_cube.length/2+largeeps,
--                                                  --   (-1)*bounding_cube.length/2+largeeps,
--                                                  },
--                                          },
--                              }
--                  },
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'fastest',
                                 level = level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0-2*eps,0.0,0.0},
                                                  {0.0,2.0-2*eps,0.0},
                                                  {0.0,0.0,2.0-2*eps},
                                                },
                                           origin={
                                                   -1.0+eps,
                                                   -1.0+eps,
                                                   -1.0+eps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  --   (-1)*bounding_cube.length/2+largeeps,
                                                  },
                                          },
                              }
                  },
                }
	    
