-- Configuration file for Ateles --
commpattern = os.getenv('cpat')
nprocs = os.getenv('nprocs')
level = os.getenv('level')


-- global simulation options
simulation = {
              name          = level .. '_' .. nprocs .. '_' ..  commpattern ,                 -- the name of the simualtion
              final_time    = --100.0 / math.pow(2, level) -- lead to approximately 34 iterations
                                  math.min(
                                    50000 * 100.0 * nprocs / math.pow(2, 4*level) ,  
                                    25000 * 100.0 / math.pow(2, level)  -- approx 3400 iterations
                                      )
             }

--commpattern = 'gathered_type'

-- VTK output (this is still a dummy implementation)
--output = { 
--          time      = '0.1',                                         -- time interval for VTK output
--          iteration = '',                                            -- iteration interval for VTK output
--          output_folder = './output/euler/'-- the folder the output is written to 
--         }

-- Mesh definitions --
-- mesh = './'
mesh = { predefined = 'cube',
         origin = {0.0, 0.0, 0.0},
         length = 10.0,
         refinementLevel = level
       }


restart = { ead = 'restart_read/gauss_pulse_euler_lastHeader.lua',
            write = 'restart_read/',
--            time = {useIterations = true,  min = 1 , max = 20, interval = 2}}
            time = {useIterations = false,  min = 10000000.0 , max = 1000000000.0, interval = 10000.0}}

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                                             -- the folder for the timing results
          filename = 'timing.res'                                    -- the filename of the timing results
         }


-- Equation definitions --
-- Equation definitions --
equation = {
    name   = 'maxwell',                   -- we solve maxwell's equations
    permeaPermit = {
                         -- The background permitivity and permeability
                         global = {
                                    kind = 'const',
                                    const = {1.0, 1.0},
                                  },
                       },
}


-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'muscl',             -- we use the weno scheme for reconstruction
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitEuler',    -- we use explicit runge kutta in time
               --steps = 4,                      -- we have a 3 stage 
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.3,     -- CourantFriedrichsLewy number
                         },
               },
}

-- This is a very simple example to define constant boundary condtions.
initial_condition = { 
                      displacementFieldX = 0.0,           -- displacement field , x component
                      displacementFieldY = 0.0,           -- displacement field , y component
                      displacementFieldZ = 0.0,  -- displacement field , z component
                      displacementFieldZ = { predefined='gausspulse',
                                         center={5.0, 5.0, 5.0},
                                         halfwidth=2.0,
                                         amplitude=2.0,
                                         background=1.225
                                       },
                      magneticFieldX = 0.0,  -- magnetic induction , x component
                      magneticFieldY = 0.0,  -- magnetic induction , y component
                      magneticFieldZ = 0.0,           -- magnetic induction , z component
                    }

