require('seeder')

-- global simulation options
simulation_name = 'toro1_x_euler_modg_1d'
sim_control = {
                time_control = {   
                  min = 0, 
                  max = 0.25,
                  interval = { iter = 1 },
                }
              }

check = {
          interval = 1,
        }


-- Mesh definitions --
mesh = './mesh/'

-- Equation definitions --
equation = {
    name   = 'euler_1d',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
    -- Parameters of the penalization
    porosity             = 1.0, 
    viscous_permeability = 1.0, 
    thermal_permeability = 1.0, 
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Restart settings
restart = { 
            write = './restart/',                                        
            time_control = {   
                             min = 0, 
                             max = sim_control.time_control.max, 
                             interval = sim_control.time_control.max/2,
                          },  
          }


---- Tracking              
--tracking = { 
--             label = 'probe_density_Q4_toro_x',
--             folder = './',
--             variable = {'density'}, 
--             shape = {
--                      kind = 'canoND', 
--                      object= { origin = {
--                                           (channel_length/2.0) + epsx, 
--                                           epsx, 
--                                           epsx
--                                         } 
--                              } 
--                     },
--             time_control = {
--               min = 0, 
--               max = sim_control.time_control.max, 
--               interval = sim_control.time_control.max/20.0
--             },  
--             format = 'ascii' 
-- }

-- The initial conditions for the Riemann problem
-- ... left state
rho_l = 1.0
u_l = 0.0
p_l = 1.0
-- ... right state
rho_r = 0.125
u_r = 0.0
p_r = 0.1

function rho(x,y,z)
    if( x < channel_length/2.0 ) then
        return rho_l
    else
        return rho_r
    end
end

function p(x,y,z)
    if( x < channel_length/2.0 ) then
        return p_l
    else
        return p_r
    end
end

function u(x,y,z)
    if( x < channel_length/2.0 ) then
        return u_l
    else
        return u_r
    end
end

function velX(x,y,z)
    return u(x,y,z)
end

projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattoPoints = false  -- if lobatto points should be used, default = false
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              blocksize = 32,        -- for fpt, default -1
           -- fftMultiThread = false -- for fpt, logical, default false
             }

initial_condition = { 
                      density = rho,
                      pressure = p,
                      velocityX = velX,
             }

-- Scheme definitions --
filter_order = 14
scheme = {
           -- the spatial discretization scheme
           spatial =  {
                      name = 'modg_1d',             
                      m =  31,                
                      }, 
           ------ the stabilzation of the scheme
           stabilization = {
                             {
                              name = 'spectral_viscosity',
                              alpha = 36,
                              order = filter_order,
                             },
                             {
                              name = 'covolume',
                              alpha = 36,
                              order = filter_order,
                              beta = 1.0,
                             },
                           },
           -- the temporal discretization scheme
           temporal = {
                      name = 'explicitRungeKutta',  
                      steps = 4,
                      control = {
                                 name = 'cfl',   
                                 cfl  = 0.6*3,     
                                },
                      },
}

-- Boundary conditions
boundary_condition = {
        { 
         label = 'inlet', 
         kind = 'inflow_normal',
         density = rho_l,
         v_norm = u_l,
	}
         ,
        { 
         label = 'outlet', 
         kind = 'outflow',
         pressure = p_r,
         }
         ,
        { 
         label = 'bottom', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'top', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'south', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'north', 
         kind = 'slipwall', 
         }
}


