######################################## TEX FILES ###############################################################

reset
set terminal latex
set out "plots/shuosher_density.tex"

set xlabel '$x$'
set ylabel "\\rotatebox{90}{density}"

plot './harvest/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:4 w l title 'raw', \
     './harvest_postProcessed/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:4 w l title 'post-processed'


reset
set terminal latex
set out "plots/shuosher_velocity.tex"

set xlabel '$x$'
set ylabel "\\rotatebox{90}{velocity}"

plot './harvest/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:5 w l title 'raw', \
     './harvest_postProcessed/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:5 w l title 'post-processed'


reset
set terminal latex
set out "plots/shuosher_pressure.tex"

set xlabel '$x$'
set ylabel "\\rotatebox{90}{pressure}"

plot './harvest/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:6 w l title 'raw', \
     './harvest_postProcessed/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:6 w l title 'post-processed'

######################################## EPS FILES ###############################################################

reset
set terminal post enh eps color solid
set out "plots/shuosher_density.eps"

set xlabel 'x'
set ylabel 'density'

plot './harvest/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:4 w l title 'raw', \
     './harvest_postProcessed/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:4 w l title 'post-processed'


reset
set terminal post enh eps color solid
set out "plots/shuosher_velocity.eps"

set xlabel 'x'
set ylabel 'velocity'

plot './harvest/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:5 w l title 'raw', \
     './harvest_postProcessed/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:5 w l title 'post-processed'


reset
set terminal post enh eps color solid
set out "plots/shuosher_pressure.eps"

set xlabel 'x'
set ylabel 'pressure'

plot './harvest/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:6 w l title 'raw', \
     './harvest_postProcessed/shuosher_x_euler_modg_1d_track_p00000_t3.000E+00.res' u 1:6 w l title 'post-processed'
