require('seeder')

-- global simulation options
simulation_name = 'shuosher_x_euler_modg_1d'
sim_control = {
                time_control = {   
                  min = 0, 
                  max = 3.0,
                  interval = { iter = 1 },
                }
              }

check = {
          interval = 1,
        }


-- Mesh definitions --
mesh = './mesh/'

-- Equation definitions --
equation = {
    name   = 'euler_1d',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
    -- Parameters of the penalization
    porosity             = 1.0, 
    viscous_permeability = 1.0, 
    thermal_permeability = 1.0, 
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Restart settings
restart = { 
            write = './restart/',                                        
            time_control = {   
                             min = 0, 
                             max = sim_control.time_control.max, 
                             interval = sim_control.time_control.max/2,
                          },  
          }


-- The initial conditions for the Riemann problem
-- ... right state
rho_r = 1.0
u_r = 0
p_r = 1.0
mach_r = u_r/math.sqrt( equation.isen_coef * p_r / rho_r )

-- The shock speed
shockMach = 2.0
shockSpeed = shockMach * math.sqrt(equation.isen_coef * p_r / rho_r )

-- ... left state
chi = ( u_r - shockSpeed ) / math.sqrt(equation.isen_coef * p_r / rho_r )
rho_l = rho_r * ( ((equation.isen_coef+1)*chi*chi) / ((equation.isen_coef-1)*chi*chi+2) )  
u_l = shockSpeed + ( u_r - shockSpeed ) * (rho_r/rho_l) 
p_l = p_r * ( (2*equation.isen_coef*chi*chi-(equation.isen_coef-1)) / (equation.isen_coef+1) ) 
mach_l = u_l/math.sqrt( equation.isen_coef * p_l / rho_l )


function rho(x,y,z)
    if( x < 1 ) then
        return rho_l
    else
        return 1+0.2*math.sin(5*math.pi*(x-5))
    end
end

function p(x,y,z)
    if( x < 1 ) then
        return p_l
    else
        return p_r
    end
end

function velX(x,y,z)
    if( x < 1 ) then
        return u_l
    else
        return u_r
    end
end

projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattoPoints = false  -- if lobatto points should be used, default = false
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              blocksize = 32,        -- for fpt, default -1
           -- fftMultiThread = false -- for fpt, logical, default false
             }

initial_condition = { 
                      density = rho,
                      pressure = p,
                      velocity = velX,
             }

-- Scheme definitions --
filter_order = 18
alp = 36
scheme = {
           -- the spatial discretization scheme
           spatial =  {
                      name = 'modg_1d',             
                      m = 31,                
                      }, 
           ------ the stabilzation of the scheme
           stabilization = {
                             {
                              name = 'spectral_viscosity',
                              alpha = alp,
                              order = filter_order,
                             },
                             {
                              name = 'covolume',
                              alpha = alp,
                              order = filter_order,
                              beta = 1.0,
                             },
                           },
           -- the temporal discretization scheme
           temporal = {
                      name = 'explicitRungeKutta',  
                      steps = 4,
                      control = {
                                 name = 'cfl',   
                                 cfl  = 0.6*3,     
                                },
                      },
}

-- Boundary conditions
boundary_condition = {
        { 
         label = 'inlet', 
         --TODO kind = 'inflow_normal',
         --TODO density = rho_l,
         --TODO v_norm = u_l,
         kind = 'primitives',
         density = rho_l,
         v_x = u_l,
         pressure = p_l,
	}
         ,
        { 
         label = 'outlet', 
         kind = 'outflow',
         pressure = p_r,
         }
         ,
        { 
         label = 'bottom', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'top', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'south', 
         kind = 'slipwall', 
         }
         ,
        { 
         label = 'north', 
         kind = 'slipwall', 
         }
}


