logging = {level=5}
L     = 2.0*math.pi
kx    = 1
ky    = 1
x0    = { 0.0, 0.0, 0.0 }
ucx   = 0
ucy   = 0

level = os.getenv("LEVEL")
level = 2
P     = os.getenv("P")
if ( P == nil ) then
  P = 16
end
simulation_name = 'ateles_tgv_L'..level..'_P'..P

dx    = L / ( 2^level )
dx_h  = dx / 2.0
delta = 1e-5
-- ply_sampling = { nlevels = 2 }

Re         = 1600
tD         = Re / 2
tEnd       = 10 / 100
Pr         = 0.75
cfl        = 0.5
cfl_visc   = 0.5
rho        = 1.0
u0         = 1.0
p0         = 64.0
mu         = 1 / Re
-- Gamma should close to 1
gamma      = 1.01 -- Gamma must > 1
cs         = math.sqrt( gamma * p0 / rho )
Mach       = u0 / cs
-- Mach       = 0.3
-- gamma      = rho / ( Mach * Mach * p0 )
-- R should be small
R          = 1.0 / 10
Cv         = R / ( gamma - 1.0 )
Cp         = R + Cv
-- Pr         = Cp * mu / kappa
kappa      = Cp * mu / Pr
-- Mach = 1.0 / ( math.sqrt(gamma * p0 / rho ) )
probe_point = { L/3, L/3, delta }
-- print("Mach = "..Mach)

-- dt = cfl * h / (P^2)
--  max_velocity =  maxval(   abs(timestep%euler%maxVel(:)) &
--                          + abs(timestep%euler%speedOfSound(:)) )
--
--  dt_conv =  cfl_conv * length / max_velocity / 2._rk / (nPoly**2)
--  dt_visc = cfl_visc * length**2  / ( max( mu, therm_cond ) ) / real(nPoly**4,rk)
--  dt = min(dt_conv, dt_visc)
dt_visc = cfl * (dx^2) / math.max(mu,kappa) / (P^4)
dt_conv = cfl * dx / math.max(u0, cs) / 2.0 / (P^2)
dt = math.min(dt_conv, dt_visc)
tMax = math.ceil( tEnd / dt )
-- print("tMax = "..tMax)

sim_control = {
  time_control = {
    max = tEnd,
    interval = tEnd / 10,
  },
}
check = { interval = tMax / 10, }
printRuntimeInfo = false

mesh = {
  predefined = 'cube',
  origin = { 0.0, 0.0, 0.0 },
  length = L,
  refinementLevel = level,
}
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0,0.0}
end
relax_temperature = 0.0

-- Tracking
tracking = {
  {
    label = 'ke',
    folder = './tracking/',
    variable = { 'kinetic_energy' },
    output = { format = 'ascii', ndofs = 1},
    -- reduction = {'average'},
    shape = {
      kind = 'global',
    },
    time_control = { min = 0, max = tEnd, interval = 0.1, },
  },
  -- {
  --   label = 'global',
  --   folder = './tracking/',
  --   variable = { 'density', 'energy', 'pressure', 'momentum' },
  --   output = { format = 'vtk' },
  --   -- output = { format = 'ascii', use_get_point = false, ndofs = 2},
  --   -- reduction = {'average', 'average', 'average' },
  --   shape = {
  --     kind = 'global',
  --     -- object= {
  --     --   origin = probe_point,
  --     -- },
  --   },
  --   time_control = { min = 0, max = tEnd, interval = tEnd / 10, },
  -- },
}
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',
    m = P-1,
  },
  -- stabilization = {name = 'covolume', beta = 1.0},
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitRungeKutta',
    steps = 4,
    control = {
      name = 'cfl',
      cfl = cfl,
      cfl_visc = cfl_visc,
    },
  },
}

-- Equation definitions --
-- ... the smallness parameter of the penalization
penalization_eps = 8.0/(scheme.spatial.m+1)
penalization_alpha = 1.0
equation = {
  penalization = {
    global = {
      kind = 'const',
      const = {0.0, 0.0, 0.0, 0.0},
    },
  },
  name       = 'navier_stokes',
  -- general fluid's parameter
  isen_coef  = gamma,
  r          = R,
  -- viscous parameters
  therm_cond = kappa,
  mu         = mu,
  ip_param   = 4.0, -- The stabilization parameter for the Interior Penalty discretization
  -- Parameters of the penalization
  porosity             = penalization_eps,
  viscous_permeability = penalization_alpha*penalization_eps,
  thermal_permeability = penalization_alpha*penalization_eps,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

projection = { kind = 'fpt', factor = 1.0, }

-- Pressure
function pressure(x,y,z,t)
  p = (math.cos(2*x)+math.cos(2*y)) * ( math.cos(2*z) + 2.0 )
  return p0 + u0^2 * p * rho / 16.0
end
function ic_pressure(x,y,z)
  return pressure(x,y,z,0)
end

-- velocity X
function velocityX(x,y,z,t)
  return  u0 * math.sin(x) * math.cos(y) * math.cos(z)
end
function ic_velocityX(x,y,z)
  return velocityX(x,y,z,0)
end

-- velocity Y
function velocityY(x,y,z,t)
  return -u0 * math.cos(x) * math.sin(y) * math.cos(z)
end
function ic_velocityY(x,y,z)
  return velocityY(x,y,z,0)
end

-- velocity Z
function ic_velocityZ(x,y,z)
  return 0.0
end

-- velocity in 2D
function velocity(x, y, z, t)
  return { velocityX( x,y,z,t ), velocityY( x,y,z,t ), 0 }
end

initial_condition = {
  density   = rho,
  pressure  = ic_pressure,
  velocityX = ic_velocityX,
  velocityY = ic_velocityY,
  velocityZ = 0,
  useFpt = true,
}
variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 2,
     vartype = "st_fun",
     --st_fun = relax_velocity
     st_fun = {const = {0.0,0.0}}
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
  -- analytical solution
  -- { name = 'refP',  ncomponents = 1, st_fun = pressure, vartype = 'st_fun',  },
  -- { name = 'refV',  ncomponents = 2, st_fun = velocity, vartype = 'st_fun' },
  -- { name = 'errorP',     ncomponents = 1, vartype = 'operation',
  --   operation = {
  --     kind = 'difference',
  --     input_varname = { 'pressure', 'refP' },
  --   },
  -- },
  -- { name = 'errorV',     ncomponents = 2, vartype = 'operation',
  --   operation = {
  --     kind = 'difference',
  --     input_varname = { 'velocity', 'refV' },
  --   },
  -- },
}
