#!/bin/bash
#SBATCH --time=0:30:00
#SBATCH --mail-type=Fail
#SBATCH --mail-user=raphael.haupt@student.uni-siegen.de
#SBATCH --exclusive
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=12
#SBATCH --partition=short

#Load used modules
module purge
module load default-environment
module load PrgEnv/intel-openmpi/15.0.1-1.8.1
module load PerfEnv/intel-openmpi/15.0.1-1.8.1
module list

# Set Scorep parameter
export SCOREP_EXPERIMENT_DIRECTORY='intel_filter'  # directory name
export SCOREP_ENABLE_PROFILING=true                # profiling 
export SCOREP_ENABLE_TRACING=false                 # tracing
export SCOREP_FILTERING_FILE='filt.filt'           # name of filter used
export SCOREP_MPI_ENABLE_GROUPS='NONE'             # mpi routines watched

# Ateles parameters
export LEVEL=2
echo LEVEL = $LEVEL
export P=6
echo P = $P
export LOGGING=10
echo LOGGING LEVEL = $LOGGING

# executables
#  !! ateles must be build with Scorep or Scalasca !!
export ateles='/home/g001570/apes/ateles/build/scorep/ateles'

# Logfile
export ateles_log='ateles.log'

# 1 = yes, 0 = no
runateles='1'

# Run ateles 
if [ ${runateles} == "1" ]; then
  echo run ateles
  rm ${ateles_log}
    scan mpiexec ${ateles} | tee ${ateles_log}
  echo done with ateles 
fi

# Postprocess data
scalasca -examine -s $SCOREP_EXPERIMENT_DIRECTORY                          # Generate scalasca date
scorep-score $SCOREP_EXPERIMENT_DIRECTORY/pofile.cubex -r > result.log     # Generate logfile with timings


echo end Programm
