---- testcase setup------------------------------------------------------------

-- material
gamma      = 1.4
r          = 280.0
therm_cond = 0.015625
mu         = 1.0e-6  

-- initial flow
dens = 1.0
velX = 0.0
velY = 0.0
velZ = 0.0
press = 1/gamma

--gauss pulse
c = math.sqrt(gamma* press / dens)
gp_center = {0.0, 0.0, 0.5}
gp_halfwidth = 3.0
gp_amplitude = 0.001
gp_background = press
gp_c = c

-- simulation
degree = 11 --5
cfl= 0.5
dt = 0.015

-- initial condition --
initial_condition = {
  density = dens,
  velocityX = velX,
  velocityY = velY,
  velocityZ = velZ,
  pressure = { 
    predefined = 'gausspulse',
    center     = gp_center,
    halfwidth  = gp_halfwidth,
    amplitude  = gp_amplitude,
    background = gp_background
  },
}

-----simulation setup-----------------------------------------------------------
logging = {level=7}
timestep_info = 1
check =  { interval = 1 }
tmax = 35.0
track_dt = 0.01
line_track_dt = 2.0
restart_dt = 1.0
sim_control = {
  time_control = {
    min = 0,
    max = tmax,
    interval = {iter = 100}, -- final simulation time
  }
}
-- the general projection table --
projection = {
  kind = 'fpt',
  factor = 1.0,
}

