require 'common'

-- simulation controll parameter-----------------------------------------------
logging = {level=1}
timing_file = 'timing.res'
simulation_name='ateles' 

sim_control = {
  time_control = {
    min = 0,
    max = tmax,
    interval = {iter = 100}, 
  }
}

-- Restart -------------------------------------------------------------------
NOrestart = {
  write = 'restart/',
  time_control = {
    min = 0,
    max = tmax,
    interval = {sim = restart_dt, clock = 7000}, -- final simulation time
  },
}

-- Tracking
segments = 4*(degree+1)
tracking = {
  -- Line tracking
  {
    label = 'lineX_pressure',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        origin   = { -2.0, 0.0, 0.0 },
        vec      = { 4.0, 0.0 ,0.0},
        segments = { segments},
      },
    },
    time_control = {min = 0, max = tmax, interval = line_track_dt},
    output = { format = 'asciiSpatial', use_get_point = true},
  },
  -- Point tracking
  {
    label = 'center',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- close to center
        { origin = { 0.0, 0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval = {iter=1}},
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'west',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { -1,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
  {
    label = 'east',
    folder = './track_pulse/euler/',
    variable = {'pressure', 'ref_pressure', 'error'},
    shape = {
      kind = 'canoND',
      object = {
        -- point west 
        { origin = { 1.0,0.0, 0.0 }},
      },
    },
    time_control = {min = 0, max = tmax, interval ={iter=1} },
    output = { format = 'ascii', use_get_point = true},
  },
}

-- Variable system definintion--
characteristic = 0.0
function relax_velocity(x,y,z,t)
  return {0.0, 0.0, 0.0}
end
relax_temperature = 0.0

variable = {
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 3,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
  {
     name = 'ref_pressure',
     ncomponents = 1,
     vartype ='st_fun',
     st_fun = { 
       predefined = 'acoustic_pulse',
       center     = gp_center,
       halfwidth  = gp_halfwidth,
       amplitude  = gp_amplitude,
       background = gp_background,
       speed_of_sound = gp_c,
     }
  },
  {
     name = 'error',
     ncomponents = 1,
     vartype = 'operation',
     operation = {
       kind = 'difference',
       input_varname = {'pressure', 'ref_pressure'},
    }
  },
}

-- Mesh definitions --
mesh = 'mesh/'

-- Scheme definitions --
scheme = {
  -- the spatial discretization scheme
  spatial =  {
    name = 'modg',
    modg_space = 'Q',
    m = degree,
  },
  -- the temporal discretization scheme
  temporal = {
    name = 'explicitSSPRungeKutta',
    steps = 2,
    control = {
      name = 'cfl',
      cfl = 0.9
      --name = 'fixed',
      --dt = dt
    },
  },
}

-- Equation definitions -------------------------------------------------------
equation = {
  name = 'euler',
  isen_coef = gamma,
  r = 296.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

 -- Boundary definitions
boundary_condition = {
  {
    label = 'outside',
    kind = 'primitives',
    density = dens,
    velocityX = velX,
    velocityY = velY,
    velocityZ = velZ,
    pressure  = press,
  },
}
