-- Configuration file for Ateles --
sim_name = 'cylinder'
sim_control = {
                time_control = {   
                                 max = 2.0,
                                 interval = { iter = 10 },
                               }
             }
logging = { level = 10 }

-- Check for Nans and unphysical values
check =  { interval = 1 }


-- the order of the scheme:
spatial_order = 15
filter_order = 30 

-- Restart settings
io_buffer_size = 20
-- Tracking              
tracking = {
             label = 'track_momentum',
             folder = './',
             variable = {'velocity'},
             shape = {kind = 'canoND', object= { origin ={-1., 0., -1.}, vec = {2.0, 0.0, 0.0} } },
             time_control = {
               min = 0,
               max = sim_control.time_control.max,
             --  interval = 0.01
             },
             format = 'asciiSpatial'
           }
restart = { 
            --read  = 'restart/simulation_lastHeader.lua',
            write = 'restart/eps_0.01_p15_30/',                                        
            time_control = {   
                            min = 0, 
                            max = sim_control.time_control.max, 
                            interval = 0.2,
                           },  
          }

-- ...the initial condition table. 
isen = 1.4
boltz= 1.0/1.4
rho  = 1.4
p    = 1.0
-- ... define background velocity (ATTENTION: change boundaries accordingly)
vel  = 0.1 * math.sqrt(isen * p / rho ) --TODO 0.6 --TODO 1.1

-- ... define the temperature in the penalization area
temp = p / ( rho * boltz )

-- ... the smallness parameter of the penalization
penalization_eps = 0.01
penalization_alpha = 0.01 --TODO 0.1 --TODO = 0.01

mesh = { predefined = 'slice',
         origin = {-1,-1,-1},
         length = 2,
         refinementLevel = 3
       }
cylinder_radius = 0.5

function obstacle_function(x,y,z,t)
  radius = math.sqrt(x^2 + y^2 )
  if radius < cylinder_radius then
    return { 1.0, 0.0, 0.0, temp }
  else
    return { 0.0, 0.0, 0.0, 0.0 }
  end
end

-- Scheme definitions --
scheme = {
    spatial =  {
                  name = 'modg_2d',          
                  m = spatial_order-1,                 
               }, 
    temporal = {
               name = 'explicitRungeKutta',
               steps = 4,
               --   name = 'explicitSSPRungeKutta',  
               --   steps = 2,
                  control = {
                             name     = 'cfl', 
                             cfl      = 0.8,
                             --cfl_visc = 0.1,
                            },
               },
     stabilization = {
                       {
                          name = 'spectral_viscosity',
                          alpha = 32,
                          order =filter_order,
                       },
                       {
                          name = 'covolume',
                          alpha = 36,
                          order = filter_order,
                          beta = 1.0 - 2.0/spatial_order,
                         }
--     --                   {
--     --                      name = 'cons_positivity_preserv',
--     --                      eps = 1e-6,
--     --                   },
                     }
}


-- ...the general projection table
projection = {
              kind = 'fpt',
              -- lobattoPoints = true,
              factor = 2.0,
              blocksize = 32,
              -- fftmultithread = true,
             }

-- Equation definitions --
equation = {
    name   = 'euler_2d',                 
    -- The definition of an obstacle by penalization
    penalization = {
                     {
                        kind = 'lua_fun',
                        fun = obstacle_function,
                        shape={ 
                                  kind = 'canoND',
                                  object = {origin = {-0.5, -0.5, -0.995},
                                            vec = { {1.0,0.0,0.0},{0.0,1.0,0.0} }, 
                                            segments = {20,20}, 
                                           }
                              }
                     },
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
    -- Physical parameters of the gas phase
    isen_coef            = isen,
    r                    = boltz,
    -- Parameters of the penalization
    porosity             = penalization_eps,
    viscous_permeability = penalization_alpha*penalization_eps,
    thermal_permeability = penalization_alpha*penalization_eps,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Initial condition definitions --
function iniVel(x,y,z)
  radius = math.sqrt(x^2 + y^2 )
  if radius < cylinder_radius then
    return 0.0
  else
    return vel
  end
end
initial_condition = { 
                      density  = rho,
                      pressure = p,
                      velocityX = iniVel,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }
