require('common_2d')

-- Equation definitions --
equation = {
    -- Physical parameters of the gas phase
    name   = 'navier_stokes_2d',
    isen_coef = isen_coef,
    r      = r,
    -- Parameters of the penalization
    porosity             = 1,
    viscous_permeability = 1,
    thermal_permeability = 1,
    -- The definition of an obstacle by penalization
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
    -- Physical parameters of the viscous terms
    mu                   = 1e-2/4.0/4.0,    --TODO 1.0
    therm_cond           = 0.0,             --TODO 1.0
    ip_param             = 4.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


