--Configuration 4

require('quadrant')

-- Filter order for the Covolume stabilization and spectral viscosity
filter_order = 4

final_sim_time = 0.25

-- Initial condition for density
function ini_dens(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 1.1
  elseif(quad == 2) then
    return 0.5065
  elseif(quad == 3) then
    return 1.1
  else
    return 0.5065
  end
end

-- Initial condition for pressure
function ini_press(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 1.1
  elseif(quad == 2) then
    return 0.35
  elseif(quad == 3) then
    return 1.1
  else
    return 0.35
  end
end

-- Initial condition for velocity (x-component)
function ini_vel_X(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 0
  elseif(quad == 2) then
    return 0.8939
  elseif(quad == 3) then
    return 0.8939
  else
    return 0
  end
end


-- Initial condition for velocity (y-component)
function ini_vel_Y(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 0
  elseif(quad == 2) then
    return 0
  elseif(quad == 3) then
    return 0.8939
  else
    return 0.8939
  end
end

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'slipWest_QuadII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipWest_QuadIII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipEast_QuadI', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipEast_QuadIV', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipSouth_QuadIII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipSouth_QuadIV', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipNorth_QuadII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipNorth_QuadI', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipBottom', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipTop', 
                       kind = 'supersonic_outflow',       
                       },
                     }  
