#!/bin/bash
#SBATCH --time=48:00:00
#SBATCH --mail-type=END
#SBATCH --mail-user=j.zudrop@grs-sim.de
#SBATCH -N 8
#SBATCH --exclusive

export NPROCS=64

# Loop over all the test cases
## in rrrr ssjj jjjj jjrr sjjr ssss
for case in  rrrr ssjj jjrr sjjr
do

# Remove old data
rm mesh/*
rm -rf harvest
rm -rf restart
rm -rf harvest_postProcessed
rm -rf restart_postProcessed
rm -rf log

# Create tmp storage
mkdir mesh
mkdir restart
mkdir harvest
mkdir harvest/mesh/
mkdir log

# export case for Lua configuration
export riemann=$case

echo "-----------------------------------------------------------"
echo "Running 2D-Riemann problem: $case"
export logfile=log/atl_"$case".txt
export logfile_post=log/atl_"$case"_post.txt

# create the mesh
../../../../seeder/build/debug/seeder > log/sdr.txt
mpiexec -n $NPROCS ../../../../harvester/build/harvester harvester_mesh.lua > log/hvs_mesh.txt


# run the solver
echo 'Running solver ....'
mpiexec -n $NPROCS ../../../build/ateles > $logfile

# post-process the raw data
echo 'Raw data to VTK ....'
mpiexec -n $NPROCS ../../../../harvester/build/harvester > log/hvs_raw.txt

mkdir restart_postProcessed
mkdir harvest_postProcessed

# Post-Process the data to remove Gibbs oscillations
echo 'Post-process raw-data ...'
mpiexec -n $NPROCS ../../../build/ateles ateles_postProcess.lua > $logfile_post

# post-process the post-processed data
echo 'Post-processed data to VTU ...'
mpiexec -n $NPROCS ../../../../harvester/build/harvester harvester_postProcess.lua > log/hvs_post.txt

# Save the data
export datfolder="$case"_data
rm -rf $datfolder
mkdir $datfolder
mv mesh $datfolder/mesh
mv restart $datfolder/restart
mv restart_postProcessed $datfolder/restart_postProcessed
mv harvest $datfolder/harvest
mv harvest_postProcessed $datfolder/harvest_postProcessed
mv log $datfolder/log

echo "Done with $case ..."

done
