--Configuration 6

require('quadrant')

-- Filter order for the Covolume stabilization and spectral viscosity
filter_order = 8

final_sim_time = 0.3

-- Initial condition for density
function ini_dens(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 1
  elseif(quad == 2) then
    return 2
  elseif(quad == 3) then
    return 1
  else
    return 3
  end
end

-- Initial condition for pressure
function ini_press(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 1
  elseif(quad == 2) then
    return 1
  elseif(quad == 3) then
    return 1
  else
    return 1
  end
end

-- Initial condition for velocity (x-component)
function ini_vel_X(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return 0.75
  elseif(quad == 2) then
    return 0.75
  elseif(quad == 3) then
    return -0.75
  else
    return -0.75
  end
end


-- Initial condition for velocity (y-component)
function ini_vel_Y(x,y,z)
  -- get the quadrant
  quad = get_quadrant(x,y)

  if(quad == 1) then
    return -0.5
  elseif(quad == 2) then
    return 0.5
  elseif(quad == 3) then
    return 0.5
  else
    return -0.5
  end
end

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'slipWest_QuadII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipWest_QuadIII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipEast_QuadI', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipEast_QuadIV', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipSouth_QuadIII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipSouth_QuadIV', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipNorth_QuadII', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipNorth_QuadI', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipBottom', 
                       kind = 'supersonic_outflow',       
                       },
                       { 
                       label = 'slipTop', 
                       kind = 'supersonic_outflow',       
                       },
                     }  
