-- Configuration file for Ateles --

case = os.getenv('riemann')
--print('Setting up ateles for case: ', case)

if case=='rrrr' then
  require('rrrr/rrrr')
elseif case=='ssjj' then
  require('ssjj/ssjj')
elseif case=='sjjr' then
  require('sjjr/sjjr')
elseif case=='jjjj' then
  require('jjjj/jjjj')
elseif case=='ssss' then
  require('ssss/ssss')
elseif case=='jjrr' then
  require('jjrr/jjrr')
end 

-- global simulation options
simulation_name = 'riemann_2d_euler'
sim_control = {
              time_control    =  {
                                  min = 0.0,
                                  max = final_sim_time,
                                  interval = { iter = 100},
                                 }
             }

check = {
          interval = 1,
        }

-- Mesh definitions --
mesh = './mesh/'


-- Restart settings
restart = { 
            write = './restart/',                                        
            time_control = {   
                             min = 0, 
                             max = sim_control.time_control.max, 
                             interval = sim_control.time_control.max/2, 
                           },  
          }

-- Equation definitions --
equation = {
    name   = 'euler_2d',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
beta = 1.0
scheme = {
    spatial =  {
               name = 'modg_2d',      
               --TODO m = 15, 
               m = 31,
               }, 
    ---- the stabilzation of the scheme
    stabilization = {
                      {
                       name = 'spectral_viscosity',
                       alpha = 36,
                       order = filter_order,
                      },
                      {
                       name = 'covolume',
                       alpha = 36,
                       order = filter_order,
                       beta = beta,
                      },
                    },
    temporal = {
               name = 'explicitRungeKutta',
               steps = 4,
               control = {
                          name = 'cfl',
                          --TODO cfl  = 0.6*3*3,   -- order 16
                          cfl  = 0.6*3*3*3, -- order 32
                         },
               },
}


-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = ini_dens,
                      pressure = ini_press,
                      velocityX = ini_vel_X,
                      velocityY = ini_vel_Y,
                    }

-- ...the general projection table
projection = {
              kind = 'fpt', 
              factor = 1.0,  
             }


