-- Use this file as template. Do not modify this file for running some testcases

outputname = 'channel'
outputpreview = true 

-- ATTENTION: the minimum is 3, otherwise you won't get any fluid element.
--minlevel = 7

--cubeLength = 16
H = 0.12
Lch = 0.45
dx=0.01

minlevel = math.ceil(math.log(2*Lch/dx)/math.log(2))
print(minlevel)
cubeLength = dx*2^minlevel
print(cubeLength)
-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {-2*dx,-2*dx,-2*dx},
                 --origin = {cubeLength/(-2.0)+dx/2,cubeLength/(-2.0)+dx/2,cubeLength/(-2.0)+dx/2},
                 length = cubeLength
                }


eps = bounding_cube.length/2^(minlevel+2)
spatial_object = 
                {
                  -- western inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'West',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,cubeLength,0.0},
                                                  {0.0,0.0,cubeLength},
                                                },
                                           origin={-eps,-eps,-eps},
                                          },
                              }
                  },
                  -- eastern outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'East',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,cubeLength,0.0},
                                                  {0.0,0.0,cubeLength},
                                                },
                                           origin={Lch+eps,-eps,-eps},
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'South',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {cubeLength,0.0,0.0},
                                                  {0.0,0.0,cubeLength},
                                                },
                                           origin={-eps,-eps,-eps},
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'North',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {cubeLength,0.0,0.0},
                                                  {0.0,0.0,cubeLength},
                                                },
                                           origin={-eps,H+eps,-eps},
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'Bottom',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {cubeLength,0.0,0.0},
                                                  {0.0,cubeLength,0.0},
                                                },
                                           origin={-eps,-eps,-eps},
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'Top',
                                 level = minlevel,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {cubeLength,0.0,0.0},
                                                  {0.0,cubeLength,0.0},
                                                },
                                           origin={-eps,-eps,dx+eps},
                                          },
                              }
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {Lch/2,H/2,eps },
                                        },
                             },
                  },
                }
	    
