-- Configuration for solve_euler_riemann

-- Isentropic expansion coefficient
isen_coef = 1.4

-- Point in time to evaluate
fintime = 0.14

npoints = 1000 --resolution for the solution

-- State left in the order of density, velocity, pressure
left = { 0.445, 0.698, 3.528 }

-- State right in the order of density, velocity, pressure
right = { 0.5, 0.0, 0.571 }

-- Write resulting time slices into files
create_files = true

-- file_prefix = 'exact'

-- Auxilary function to read data from an ascii file
function readcsv_col(file, col)
  local fp = assert(io.open (file))
  local csv = {}
  for line in fp:lines() do
    local row = {}
    for value in line:gmatch("[^ ]*") do
      if value ~= '' then
        row[#row+1] = value
      end
    end
    csv[#csv+1] = row[col]
  end

  -- csv contains now given column from the csv file
  return csv
end

-- Points in time, where to get sample the solution:
--t = {0.0, 0.1, 0.2, 0.3, 0.4}
t = { fintime }

-- Points in space, where to probe the solution in every time slice:
-- x = {-0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5}
x = {}
for i=1,npoints do
  table.insert(x, (i-0.5)/npoints - 0.5)
end

