-- Configuration file for Ateles --
require 'seeder_3d'

degree=12

-- global simulation options
simulation_name = 'jet_euler_modg'             -- the name of the simualtion
sim_control = { time_control = { min = 0.0,
                                 max = 4 ,      -- final simulation time
                                 interval = {iter=100},
                                },
               }

check = {
          interval = 100,
        }


-- Mesh definitions --
mesh = './mesh/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/04_m12_o12_pre/jet_euler_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/04_m12_o12_pre/',                                        
            -- temporal definition of restart write
            time_control = { min = 0.0,
                             max = sim_control.time_control.max,      -- final simulation time
                             interval = sim_control.time_control.max/100,      -- final simulation time
                           },
          }


-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 2.0,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  {
                      { level = minlevel,     m = degree },
                      { level = minlevel+1,   m = degree },
                      { level = middle_level, m = degree },
                      { level = middle_level+1, m = degree },
                      { level = small_level,  m = degree },
                      { level = smallest_level,  m = degree }
                    },
               }, 
    -- the stabilzation of the scheme
    stabilization = {
                      {
                       name = 'spectral_viscosity',
                       alpha = 36,
                       order = 12
                      },
                      {
                       name = 'cons_positivity_preserv',
                       eps = 1e-8,
                      },
                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitSSPRungeKutta',  --'explicitEuler',
               steps = 2,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.6,       -- CourantFriedrichsLewy number
                         },
               },
     }

-- The ambient medium
press = 1
dens = 1

-- the Mach number of the jet
mach = 0.4

jet_radius=1*smalleps
--jet_radius=3*smallesteps
jet_center_z = 0.375
jet_center_y = 0.375

-- the velocity amplitude in z direction
velAmpl = mach*math.sqrt(equation.isen_coef*press/dens) -- 0.1
densAmpl = 2.0


-- the radius of the jet
momentum_thickness = jet_radius/20

function velX_inlet(x,y,z)
  r = math.sqrt( (y-jet_center_y)*(y-jet_center_y) + (z-jet_center_z)*(z-jet_center_z)  )
  return velAmpl * (1/2) * ( 1 +  math.tanh((jet_radius-r)/(2*momentum_thickness) ) )
end 

function dens_inlet(x,y,z,t)
  tmpVel = velX_inlet(x,y,z)/velAmpl
    return dens * ( tmpVel+1)
    --return dens / ( 1 + (equation.isen_coef-1)/2*mach*mach*tmpVel*(1-tmpVel)  )
--    return dens + (densAmpl-dens)* math.sin(t/0.025 * 0.5*math.pi) / ( 1 + (equation.isen_coef-1)/2*mach*mach*tmpVel*(1-tmpVel)  )
end


--TODO -- random number for x and y velocity at initial time 
--TODO math.randomseed(1234)
--TODO function velXYIni(x,y,z)
--TODO   r = math.sqrt( x*x + y*y )
--TODO   return velAmpl * 1e-06 * math.exp( (-3/jetwidth) * r ) * ( math.tanh( -D * ( z - minzcoord) ) + 1.0 ) * math.random()
--TODO end

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = dens,
                      pressure = press,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                    }


-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
          --    blocksize = 32,
              lobattoPoints=true,
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'inflowEast',  
                       kind = 'inflow_normal',      
                       density = dens_inlet, 
--                                {
--                                  kind = 'combined',
--                                  spatial = dens_inlet,
--                                  transient = { predefined = 'smooth',  -- smooth sin function
--                                                min_factor = dens/densAmpl,
--                                                max_factor = 1.0,
--                                                from_time = 0,
--                                                to_time = 0.25
--                                              }
--				 },
                      v_norm = velX_inlet,
--                                { 
--                                  kind = 'combined',
--                                  spatial = velX_inlet,
--                                  transient = { predefined = 'smooth',  -- smooth sin function
--                                                min_factor = 0.0,
--                                                max_factor = 1.0,
--                                                from_time = 0,
--                                                to_time = 0.25
--                                               }
--                                  },
                       v_tan = 0.0,
                       }
                       ,
                       { 
                       label = 'outflowWest',  
                       kind = 'outflow',       
                       pressure = press,
                       }
                       ,
                       { 
                       label = 'slipSouth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipNorth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       }
                     }  
