require('common_3d')

mu = 1e-4
-- Equation definitions --
equation = {
  name   = 'navier_stokes',
  therm_cond = therm_cond,
  isen_coef  = isen_coef,
  r          = r,
  mu         = mu,
  ip_param   = 4.0,
  material = {
    characteristic = 'characteristic',
    relax_velocity = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

scheme.stabilization[2] = {
                           name = 'cons_positivity_preserv',
                           eps = 1e-5,
                          }
scheme.temporal = {
  name = 'explicitSSPRungeKutta', 
  steps = 2,
  control = {
    name = 'cfl', 
    cfl  = 0.6,
    cfl_visc = 0.6,
  },
}
