-- Configuration file for Ateles --
require 'seeder_3d'

degree=12

logging = {level=10}
-- global simulation options
simulation_name = 'jet_euler_modg'             -- the name of the simualtion
sim_control = { time_control = { min = 0.0,
                                 max = {iter=100, sim=1.0e+01} ,      -- final simulation time
                                 interval = {iter=1},
                                },
               }

check = {
          interval = 100,
        }


-- Mesh definitions --
mesh = './mesh/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/',                                        
            -- temporal definition of restart write
            time_control = { min = 0.0,
                             max = sim_control.time_control.max,      -- final simulation time
                             interval = 1, -- sim_control.time_control.max/1e3,
                           },
          }


-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  {
                      { level = minlevel,     m = degree },
                      { level = minlevel+1,   m = degree },
                      { level = middle_level, m = degree },
                      { level = middle_level+1, m = degree },
                      { level = small_level,  m = degree },
                      { level = smallest_level,  m = degree }
                    },
               }, 
    -- the stabilzation of the scheme
    stabilization = {
                      {
                       name = 'spectral_viscosity',
                       alpha = 36,
                       order = 10
                      },
                      {
                       name = 'cons_positivity_preserv',
                       eps = 1e-8,
                      },
                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitSSPRungeKutta',  --'explicitEuler',
               steps = 2,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.6,       -- CourantFriedrichsLewy number
                         },
               },
     }

-- The ambient medium
press = 1
dens = 1

-- the Mach number of the jet
mach = 0.6

jet_radius=smalleps
jet_center_z = 0.0
jet_center_y = 0.0

-- the velocity amplitude in z direction
velAmpl = mach*math.sqrt(equation.isen_coef*press/dens) -- 0.1
densAmpl = 2.0


-- the radius of the jet
momentum_thickness = jet_radius/20

function velX_inlet(x,y,z,t)
  r = math.sqrt( (y-jet_center_y)*(y-jet_center_y) + (z-jet_center_z)*(z-jet_center_z)  )
  return velAmpl * (1/2) * ( 1 +  math.tanh((jet_radius-r)/(2*momentum_thickness) ) )
end 

function dens_inlet(x,y,z,t)
  tmpVel = velX_inlet(x,y,z,t)/velAmpl
  return densAmpl / ( 1 + (equation.isen_coef-1)/2*mach*mach*tmpVel*(1-tmpVel)  )
end


--TODO -- random number for x and y velocity at initial time 
--TODO math.randomseed(1234)
--TODO function velXYIni(x,y,z)
--TODO   r = math.sqrt( x*x + y*y )
--TODO   return velAmpl * 1e-06 * math.exp( (-3/jetwidth) * r ) * ( math.tanh( -D * ( z - minzcoord) ) + 1.0 ) * math.random()
--TODO end

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = dens,
                      pressure = press,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                    }


-- ...the general projection table
projection = {
              kind = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
             -- blocksize = 32,
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'inflowEast',  
                       kind = 'inflow_normal',      
                       density = dens_inlet,
                       v_norm = velX_inlet,
                       v_tan = 0.0,
                       }
                       ,
                       { 
                       label = 'outflowWest',  
                       kind = 'outflow',       
                       pressure = press,
                       }
                       ,
                       { 
                       label = 'slipSouth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipNorth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       }
                     }  
