outputname = 'jet'
folder = 'mesh/'

debug = { active = true, debugMode = true, debugMesh = 'debug/' }

dx = 0.05
length = 5
halfwidth = 2

nx = math.ceil(length/dx)
ny_half = math.ceil((halfwidth)/dx)
ny = ny_half*2

nelems1d = math.max(nx+2, ny+2)
globlevel = math.ceil(math.log(nelems1d, 2))

bounding_cube = {
  origin = {-dx, -(ny_half+1)*dx, -3*dx/2},
  length = 2^globlevel * dx
}

eps = 0.001*dx

spatial_object = {
  -- INFLOW (west) side
  { attribute = {
      kind = 'boundary',
      label = 'West',
      level = globlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {
          -eps,
          -(ny_half*dx+eps),
          -(dx/2+eps)
        },
        vec = {
          {0.0,2*(ny_half*dx+eps),0.0},
          {0.0,0.0,dx+2*eps}
        }
      }
    }
  },
  -- EAST (outflow)
  { attribute = {
      kind = 'boundary',
      label = 'East',
      level = globlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {
          nx*dx+eps,
          -(ny_half*dx+eps),
          -(dx/2+eps)
        },
        vec = {
          {0.0,2*(ny_half*dx+eps),0.0},
          {0.0,0.0,dx+2*eps}
        }
      }
    }
  },
  -- SOUTH
  { attribute = {
      kind = 'boundary',
      label = 'South',
      level = globlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {
          -eps,
          -(ny_half*dx+eps),
          -(dx/2+eps)
        },
        vec = {
          {nx*dx+2*eps,0,0},
          {0,0,dx+2*eps}
        }
      }
    }
  },
  -- NORTH
  { attribute = {
      kind = 'boundary',
      label = 'North',
      level = globlevel,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {
          -eps,
          ny_half*dx+eps,
          -(dx/2+eps)
        },
        vec = {
          {nx*dx+2*eps,0,0},
          {0,0,dx+2*eps}
        }
      }
    }
  },

  -- periodic in z-direction
  {
    attribute = {
      kind = 'periodic',
      level = globlevel
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-eps,-(ny_half*dx+eps),-(dx/2+eps)},
          vec = {
            {nx*dx+2*eps, 0, 0},
            {0, 2*(ny_half*dx+eps), 0}
          }
        },
        plane2 = {
          origin = {-eps,-(ny_half*dx+eps),dx/2+eps},
          vec = {
            {0, 2*(ny_half*dx+eps), 0},
            {nx*dx+2*eps, 0, 0}
          }
        }
      }
    }
  },

  -- seed 
  {
    attribute = { kind = 'seed' },
    geometry = {
        kind = 'canoND',
        object =  { origin = {length/2+eps,eps,0} }
    }
  }
}
