-- global simulation options
name = 'fwd_face_step'
sim_control = {
              time_control  = {
                                min = 0.0,
                                max = 0.001,      
                                interval ={ iter=10 },
                              },
             }


-- Mesh definitions --
mesh = './mesh/'

check = {
          interval = 1,
        }

-- Restart settings
restart = { 
            write = './restart/',                                        
            time_control = {   
                              min = 0, 
                              max = sim_control.time_control.max, 
                              interval = sim_control.time_control.max/10,
                           },  
          }

-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',          
          filename = 'timing.res', 
         }

-- Equation definitions --
equation = {
    name   = 'euler_2d',
    isen_coef = 1.4,
    r      = 296.0,
    -- Parameters of the penalization
    porosity             = 1.0, 
    viscous_permeability = 1.0, 
    thermal_permeability = 1.0, 
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg_2d', 
               m = 3,
               dealiasFactor = 1.0, 
               blocksize = 32,
               lobattoPoints = true,
               }, 
    -- the stabilzation of the scheme
    stabilization = {
                      {
                       name = 'spectral_viscosity',
                       alpha = 36,
                       order = 10
                      },
                      --TODO {
                      --TODO    name = 'cons_positivity_preserv',
                      --TODO    eps = 1.0e-08,
                      --TODO },
                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitSSPRungeKutta',  --'explicitEuler',
               steps = 2,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.1,       -- CourantFriedrichsLewy number
                         },
               },
}

-- Some constants for initial conditions and boundary values
dens = 1.4
press = 1.0
mach = 1.2
velX = mach * math.sqrt( equation.isen_coef * press / dens ) 

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = dens,
                      pressure = press,
                      velocityX = velX,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }


-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'wall', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'west',  
                       kind = 'supersonic_inflow_normal',      
                       density = dens,
                       v_norm = velX,
                       v_tan = 0.0,
                       pressure = press,
                       }
                       ,
                       { 
                       label = 'east',  
                       kind = 'supersonic_outflow',       
                       }
                       ,
                       { 
                       label = 'left', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'right', 
                       kind = 'slipwall',       
                       }
                       ,
                     }  
