-- Use this file as template. Do not modify this file for running some testcases
outputname = 'plate'

minlevel = 4

cubeLength = 4.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

-- the level of the slip walls
geom_level = minlevel+2

-- the refinement level of the plate
plate_level = minlevel+2 --TODO minlevel+5 

-- the refinement level at the upper corner
corner_level = plate_level + 2 --TODO plate_level + 5

-- smallness parameter
eps = bounding_cube.length/(2^(corner_level+5))

-- the element size around the plate
plate_offset = 6*bounding_cube.length/(2^(geom_level+2))
plate_width = bounding_cube.length/(2^(geom_level+2))
smalleps = bounding_cube.length/(2^(geom_level+2))

-- the size of an element (belonging to minlevel)
largeeps = bounding_cube.length/(2^minlevel)

-- size of the largest element
geomeps = bounding_cube.length/(2^geom_level)

spatial_object = 
                {
                  -- eastern inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflowEast',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     (-1)*bounding_cube.length/2+largeeps,
                                                     (-1)*bounding_cube.length/2+eps,
                                                     (-1)*bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowWest',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   bounding_cube.length/2-largeeps, 
                                                   -bounding_cube.length/2+eps, 
                                                   -bounding_cube.length/2+eps, 
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    largeeps+eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipBottom',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    -eps
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipTop',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    geomeps+eps
                                                  },
                                          },
                              }
                  },
                  -- the plate in the middle
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'plate',
                                 level = plate_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {plate_width-2*eps,0.0,0.0},
                                                  {0.0,3*smalleps - 2*eps,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -64*plate_width+eps,
                                                    plate_offset+eps, 
                                                    (-1.0)*bounding_cube.length/2.0
                                                  },
                                          },
                              }
                  },
                  -- refine box upper corner
                  {
                   attribute = {
                                 kind = 'refinement',
                                 label = 'uppercorner',
                                 level = corner_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {-2*eps,0.0,0.0},
                                                  {0.0,2*eps,0.0},
                                                  {0.0,0.0,geomeps-2*eps},
                                                },
                                           origin={
                                                    -64*plate_width+eps,
                                                    plate_offset+3*smalleps-eps, 
                                                    eps,
                                                  },
                                          },
                              }
                  },
                  -- refine box lower corner
                  {
                   attribute = {
                                 kind = 'refinement',
                                 label = 'lowercorner',
                                 level = corner_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {-2*eps,0.0,0.0},
                                                  {0.0,-2*eps,0.0},
                                                  {0.0,0.0,geomeps-2*eps},
                                                },
                                           origin={
                                                    -64*plate_width+eps,
                                                    plate_offset+eps, 
                                                    eps,
                                                  },
                                          },
                              }
                  },
                  -- refine box upper corner, end of plate
                  {
                   attribute = {
                                 kind = 'refinement',
                                 label = 'uppercorner',
                                 level = corner_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {-2*eps,0.0,0.0},
                                                  {0.0,2*eps,0.0},
                                                  {0.0,0.0,geomeps-2*eps},
                                                },
                                           origin={
                                                    -63*plate_width+eps,
                                                    plate_offset+3*smalleps-eps, 
                                                    eps,
                                                  },
                                          },
                              }
                  },
                  -- refine box lower corner, end of plate
                  {
                   attribute = {
                                 kind = 'refinement',
                                 label = 'lowercorner',
                                 level = corner_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {-2*eps,0.0,0.0},
                                                  {0.0,-2*eps,0.0},
                                                  {0.0,0.0,geomeps-2*eps},
                                                },
                                           origin={
                                                    -63*plate_width+eps,
                                                    plate_offset+eps, 
                                                    eps,
                                                  },
                                          },
                              }
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {eps,eps,eps},

                                        },
                             },
                  },
                }
	    
