-- Configuration file for Ateles --
require 'seeder_3d'


logging = {level=10}
-- global simulation options
simulation_name = 'plate_euler_modg'             -- the name of the simualtion
sim_control = { time_control = { min = 0.0,
                                 max = 1.0e+01,      -- final simulation time
                                 interval = {iter=100},
                                },
               }

check = {
          interval = 100,
        }


-- Mesh definitions --
mesh = './mesh/'


-- Restart settings
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = './restart/',                                        
            -- temporal definition of restart write
            time_control = { min = 0.0,
                             max = sim_control.time_control.max,      -- final simulation time
                             interval = sim_control.time_control.max/1e3,
                           },
          }


-- timing settings (i.e. output for performance measurements, this table is otional)
timing = {
          folder = './',                  -- the folder for the timing results
          filename = 'timing.res'         -- the filename of the timing results
         }

-- Equation definitions --
equation = {
    name   = 'euler',
    therm_cond = 2.555e-02,
    isen_coef = 1.4,
    r      = 296.0,
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)


-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  {
                      { level = minlevel,      m =15 },
                      { level = plate_level-3, m =15 },
                      { level = plate_level-2, m =15 },
                      { level = plate_level-1, m =15 },
                      { level = plate_level,   m =15 },
                    },
               }, 
    -- the stabilzation of the scheme
    stabilization = {
                       -- Spectral viscosity, i.e.:
                       -- u(x) = \sum_{k=0}^N \sigma_k \hat{u}_k L_k(x)
                       -- with
                       -- \sigma_k = exp(- \alpha (k/N)^order )
                       name = 'spectral_viscosity',
                       alpha = 36,
                       order = 6,
                    },
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitRungeKutta',  --'explicitEuler',
               steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.6,       -- CourantFriedrichsLewy number
                         },
               },
}

-- Initial condition for velocity, density and pressure
iniVelX = 0.30 
iniDens = 2.0
iniPress = 1.0 

-- This is a very simple example to define constant boundary condtions.
initial_condition = { density = iniDens,
                      pressure = iniPress,
                      velocityX = iniVelX,
                      velocityY = 0.0,
                      velocityZ = 0.0, 
                    }


-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
              blocksize = 32,
           -- fftmultithread = false -- for fpt, logical, default false
             }

-- Boundary definitions
boundary_condition = {
                       { 
                       label = 'inflowEast',  
                       kind = 'inflow_normal',      
                       density = iniDens,
                       v_norm = iniVelX,
                       v_tan = 0.0,
                       }
                       ,
                       { 
                       label = 'outflowWest',  
                       kind = 'outflow',       
                       pressure = iniPress,
                       }
                       ,
                       { 
                       label = 'slipSouth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipNorth', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipTop', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'slipBottom', 
                       kind = 'slipwall',       
                       }
                       ,
                       { 
                       label = 'plate', 
                       kind = 'slipwall',       
                       }
                       ,
                     }  
