require('common_2d')

-- Equation definitions --
equation = {
    name   = 'euler_2d',
    -- Physical parameters of the gas phase
    isen_coef = 1.4, 
    r      = 296.0,
    -- Parameters of the penalization
    porosity             = 1.0, 
    viscous_permeability = 1.0, 
    thermal_permeability = 1.0, 
    penalization = {
                     global = {
                                kind = 'const',
                                const = {0.0, 0.0, 0.0, 0.0},
                              },
                   }, 
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

print('Mach number: ', iniVel/math.sqrt(equation.isen_coef*iniPress/iniDens))
