-- Use this file as template. Do not modify this file for running some testcases

outputname = 'channel'
outputpreview = true 

-- ATTENTION: the minimum is 3, otherwise you won't get any fluid element.
minlevel = 3

cubeLength = 2.0

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }


geom_level = minlevel
eps = bounding_cube.length/2^(geom_level+1)
spatial_object = 
                {
                  -- eastern inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflowEast',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,2.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={-0.5-eps,-1.0+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowWest',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,2.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={0.5+eps,-1.0+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0,0.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={-1.0+eps,-0.25-eps,-1.0+eps},
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0,0.0,0.0},
                                                  {0.0,0.0,2.0},
                                                },
                                           origin={-1.0+eps,0.25+eps,-1.0+eps},
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipBottom',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0,0.0,0.0},
                                                  {0.0,2.0,0.0},
                                                },
                                           origin={-1.0+eps,-1.0+eps,-0.25-eps},
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipTop',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2.0,0.0,0.0},
                                                  {0.0,2.0,0.0},
                                                },
                                           origin={-1.0+eps,-1.0+eps,0.25+eps},
                                          },
                              }
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {0.0,0.0,0.0 },
                                        },
                             },
                  },
                }
	    
