check = {interval = 1, tolerance = 1.0e-10}
order = 20

-- global simulation options
simulation_name = 'euler_1d'
sim_control = { time_control = {max = {iter=6000}}, interval = {iter=1} }

-- Mesh definitions --
mesh = {
     predefined = 'line_bounded',
     origin = {-1.0, 0.0, 0.0},
     length = 2.0,
     element_count = 6
}

characteristic = 0.0
relax_velocity = 0.0
relax_temperature = 0.0

variable = {
  -- This is the global material for Euler 3D. It consists of three different
  -- components, characteristics with one scalar, relax_velocity with three
  -- scalars and relax_temperature with one scalar, thus we need five scalars
  -- for this equation system.
  -- As this is the global fallback material, we define each material to be a
  -- neutral term, which in this case is 0.
  {
     name = 'characteristic',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = characteristic
  },
  {
     name = 'relax_velocity',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_velocity
  },
  {
     name = 'relax_temperature',
     ncomponents = 1,
     vartype = "st_fun",
     st_fun = relax_temperature
  },
}

-- Equation definitions --
equation = {
    name   = 'euler_1d',
    isen_coef = 1.4,
    r      = 1.0,
  material = {
    characteristic    = 'characteristic',
    relax_velocity    = 'relax_velocity',
    relax_temperature = 'relax_temperature'
  }
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)

projection = {
    kind   = 'l2p',  -- 'fpt' or 'l2p', default 'l2p'
    factor = 1.0
}

rho = 1.0
p = 1.4
v = 0.0

p_right = 1.0

function ini_p(x, y, z)
  if x < 0 then
    return p
  else
    return p_right
  end
end

initial_condition = {
    density  = rho,
    pressure = ini_p,
    velocity = v
}

-- Scheme definitions --
scheme = {
    spatial =  {
        name = 'modg_1d',
        m    = order-1,
    },
    temporal = {
        name = 'explicitRungeKutta',
        steps = 4,
        control = { name = 'cfl', cfl  = 0.6 }
    }
}

-- Boundary conditions
boundary_condition = {
    {
         label = 'west',
         kind = 'inflow_normal',
         enforce_zero_grad = true,
         neumann_mode_fraction = 0,
         density = rho,
         v_norm = v
    },

    {
         label = 'east',
         kind = 'outflow',
         enforce_zero_grad = true,
         neumann_mode_fraction = 0,
         pressure = p_right
    }
}

restart = {
    write = 'restart/',
    time_control = {
        min = 0,
        max = sim_control.time_control.max,
        interval = {iter=1}
    }
}
