name = 'toro'

input = {
    read = os.getenv('RESFILE'), --'./restart/euler_1d_lastHeader.lua',

    subsampling = {
        levels = 7,
        projection = 'QLegendrePoint'
    }

}

output = {
    folder = os.getenv('OUTDIR'),
    {  label  = '_track',
       requestedData = { variable = {{'density'},{'velocity'},{'pressure'}} },
       format = 'ASCII',
       vrtx   = { }
    }
}

logging = {level = 0}

-- Equation definitions --
equation = {
    name   = 'euler_1d',
    isen_coef = 1.4,
    r      = 1.0
}
-- (cv) heat capacity and (r) ideal gas constant
equation["cv"] = equation["r"] / (equation["isen_coef"] - 1.0)
