import os

prod_dir = 'prod'
loglevel = 'INFO'

ateles_exe = os.path.join(os.getenv('HOME'), 'Projects', 'apes', 'ateles', 'build', 'debug', 'ateles')
seeder_exe = os.path.join(os.getenv('HOME'), 'Projects', 'apes', 'seeder', 'build', 'debug', 'seeder')
harvester_exe = os.path.join(os.getenv('HOME'), 'Projects', 'apes', 'harvester', 'build', 'debug', 'harvester')

shepherd_jobs = []

shepherd_jobs.append(
    dict(
        label             = 'seeder',
        executable        = seeder_exe,
        template          = 'seeder.template',
        extension         = 'lua',
        run_exec          = True,
        run_command       = '',
        #params            = ['refineLevel', 5, 6, 7],
        params            = [['refineLevel', 5]],
        additional_params = dict(MESH='mesh/'),
        create_subdir     = ['mesh'],
        prefix            = 'sdr'
    )
)

shepherd_jobs.append(
    dict(
        label                = 'ateles',
        executable           = ateles_exe,
        template             = 'ateles.template',
        extension            = 'lua',
        depend               = ['seeder'],
        create_depend_path   = True,
        create_depend_params = True,
        run_exec             = True,
        run_command          = '',
        params               = [['order', 8]],
        additional_params    = dict(RESTART='restart/'),
        create_subdir        = ['restart'],
        prefix               = 'atl'
    )
)

shepherd_jobs.append(
    dict(
        label                = 'harvester',
        executable           = harvester_exe,
        template             = 'harvester.template',
        extension            = 'lua',
        depend               = ['ateles'],
        create_depend_path   = True,
        create_depend_params = True,
        run_exec             = True,
        run_command          = '',
        additional_params    = dict(HVS_PATH='harvest/'),
        create_subdir        = ['harvest'],
        create_dir           = False
    )
)
