import os

plot = []
show_plot = False

# The files to post-process
files='mie_scatter_track_p*_t*.res'

plots_folder=os.environ['FILTER_PLOTS_FOLDER'] 
harvest_folder=os.environ['FILTER_HARVEST_FOLDER'] + '/' + files

# Displacement field Z
plot.append(dict(kind = 'xy',data=[ harvest_folder ],
           row=[1,-1],col=[1,6],  
           startplot = True,endplot =False,  ls = 'b-o', 
           label = 't=1/f' ))
plot.append(dict(kind = 'xy',data=[ harvest_folder ],
           row=[1,-1],col=[1,10],  
           format = 'eps', xlabel = 'x', ylabel = 'displacement - Z',
           startplot =False,endplot =True,figname = plots_folder + '/displacement_z',  ls = 'g-', 
           label = 'reference' ))

# Magnetic field X
plot.append(dict(kind = 'xy',data=[ harvest_folder ],
           row=[1,-1],col=[1,7],  
           startplot = True,endplot =False,  ls = 'b-o', 
           label = 't=1/f' ))
plot.append(dict(kind = 'xy',data=[ harvest_folder ],
           row=[1,-1],col=[1,11],  
           format = 'eps', xlabel = 'x', ylabel = 'magnetic - X',
           startplot =False,endplot =True,figname = plots_folder + '/magnetic_x',  ls = 'g-', 
           label = 'reference' ))

# Magnetic field Y
plot.append(dict(kind = 'xy',data=[ harvest_folder ],
           row=[1,-1],col=[1,8],  
           startplot = True,endplot =False,  ls = 'b-o', 
           label = 't=1/f' ))
plot.append(dict(kind = 'xy',data=[ harvest_folder ],
           row=[1,-1],col=[1,12],  
           format = 'eps', xlabel = 'x', ylabel = 'magnetic - Y',
           startplot =False,endplot =True,figname = plots_folder + '/magnetic_y',  ls = 'g-', 
           label = 'reference' ))

