import os

prod_dir = 'prod'
loglevel = 'INFO'

apes_dir = os.path.join(os.getenv('HOME'), 'apes')

ateles_exe = os.path.join(apes_dir, 'ateles', 'build', 'ateles')
seeder_exe = os.path.join(apes_dir, 'seeder', 'build', 'seeder')
harvester_exe = os.path.join(apes_dir, 'harvester', 'build', 'harvester')

shepherd_jobs = []

shepherd_jobs.append(
    dict(
        label             = 'setup',
        executable        = None,
        template          = 'setup.template',
        extension         = 'lua',
        run_exec          = False,
        run_command       = '',
        params            = [ ['order', 16],
                              ['level',  5],
                              ['over',   2] ],
        prefix            = 'setup'
    )
)

shepherd_jobs.append(
    dict(
        label             = 'seeder',
        executable        = seeder_exe,
        template          = 'seeder.template',
        extension         = 'lua',
        run_exec          = True,
        run_command       = '',
        depend               = ['setup'],
        create_depend_path   = True,
        create_depend_params = True,
        params            = [ ['sublevel', 5, 6, 8, 10],
                              ['antialias',    1, 2, 4] ],
        create_subdir     = ['mesh'],
        prefix            = 'sdr'
    )
)

shepherd_jobs.append(
    dict(
        label                = 'ateles',
        executable           = ateles_exe,
        template             = 'ateles.template',
        extension            = 'lua',
        depend               = ['seeder', 'setup'],
        create_depend_path   = True,
        create_depend_params = True,
        create_dir           = False,
        run_exec             = False,
        run_command          = '',
        create_subdir        = ['restart']
    )
)

shepherd_jobs.append(
    dict(
        label                = 'batch_job',
        executable           = None,
        template             = 'horus.template',
        extension            = 'slurm',
        depend               = ['seeder', 'setup'],
        create_depend_path   = True,
        create_depend_params = True,
        run_exec             = False,
        run_command          = 'sbatch',
        create_dir           = False
    )
)

shepherd_jobs.append(
    dict(
        label                = 'harvester',
        executable           = harvester_exe,
        template             = 'harvester.lua',
        extension            = 'lua',
        depend               = ['ateles'],
        run_exec             = False,
        run_command          = '',
        create_subdir        = ['harvest'],
        create_dir           = False
    )
)
